/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import foundry.veil.ext.CompositeStateExtension;
import foundry.veil.mixin.client.stage.RenderStateShardAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.ApiStatus;

public class RenderTypeStageRegistry {
    private static final Map<String, List<RenderStateShard>> STAGES = new HashMap<String, List<RenderStateShard>>();
    private static final Set<GenericStage> GENERIC_STAGES = new HashSet<GenericStage>();
    private static final Set<RenderType.CompositeRenderType> CREATED_RENDER_TYPES = new HashSet<RenderType.CompositeRenderType>();

    public static synchronized void addStage(RenderType renderType, RenderStateShard ... shards) {
        RenderTypeStageRegistry.addStage(((RenderStateShardAccessor)renderType).getName(), shards);
    }

    public static synchronized void addStage(String name, RenderStateShard ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        STAGES.computeIfAbsent(name, unused -> new ArrayList()).addAll(Arrays.asList(shards));
        for (RenderType.CompositeRenderType renderType : CREATED_RENDER_TYPES) {
            RenderTypeStageRegistry.inject(renderType);
        }
    }

    public static synchronized void addGenericStage(Predicate<RenderType.CompositeRenderType> filter, RenderStateShard ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        GENERIC_STAGES.add(new GenericStage(filter, shards));
        for (RenderType.CompositeRenderType renderType : CREATED_RENDER_TYPES) {
            RenderTypeStageRegistry.inject(renderType);
        }
    }

    @ApiStatus.Internal
    public static void inject(RenderType.CompositeRenderType renderType) {
        List<RenderStateShard> shards = STAGES.get(((RenderStateShardAccessor)renderType).getName());
        if (shards != null) {
            shards = new ArrayList<RenderStateShard>(shards);
        }
        for (GenericStage stage : GENERIC_STAGES) {
            if (!stage.filter.test(renderType)) continue;
            if (shards == null) {
                shards = new ArrayList<RenderStateShard>(Arrays.asList(stage.shards));
                continue;
            }
            shards.addAll(Arrays.asList(stage.shards));
        }
        if (shards != null) {
            ((CompositeStateExtension)renderType.state()).veil$addShards(shards);
        }
        CREATED_RENDER_TYPES.add(renderType);
    }

    private record GenericStage(Predicate<RenderType.CompositeRenderType> filter, RenderStateShard[] shards) {
    }
}

