/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.BlitPostStage;
import foundry.veil.api.client.render.post.stage.CopyPostStage;
import foundry.veil.api.client.render.post.stage.MaskPostStage;
import net.minecraft.resources.ResourceLocation;

public class PostPipelineStageRegistry {
    private static final BiMap<ResourceLocation, PipelineType<?>> EFFECT_TYPES = HashBiMap.create();
    public static final Codec<PipelineType<?>> CODEC = ResourceLocation.CODEC.flatXmap(location -> {
        PipelineType pipelineType = (PipelineType)EFFECT_TYPES.get(location);
        if (pipelineType != null) {
            return DataResult.success((Object)pipelineType);
        }
        return DataResult.error(() -> "Unknown post pipeline type " + location);
    }, pipelineType -> {
        ResourceLocation location = (ResourceLocation)EFFECT_TYPES.inverse().get(pipelineType);
        if (pipelineType != null) {
            return DataResult.success((Object)location);
        }
        return DataResult.error(() -> "Unknown post pipeline type " + location);
    });
    public static final PipelineType<BlitPostStage> BLIT = PostPipelineStageRegistry.register("blit", BlitPostStage.CODEC);
    public static final PipelineType<CopyPostStage> COPY = PostPipelineStageRegistry.register("copy", CopyPostStage.CODEC);
    public static final PipelineType<MaskPostStage> MASK = PostPipelineStageRegistry.register("mask", MaskPostStage.CODEC);

    private static <T extends PostPipeline> PipelineType<T> register(String name, Codec<T> codec) {
        ResourceLocation location = new ResourceLocation("veil", name);
        PipelineType<T> pipelineType = new PipelineType<T>(codec);
        if (EFFECT_TYPES.putIfAbsent((Object)location, pipelineType) != null) {
            throw new IllegalStateException("Duplicate pipeline type type registration " + location);
        }
        return pipelineType;
    }

    public record PipelineType<T extends PostPipeline>(Codec<T> codec) {
    }
}

