/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.render.InterpolatedEntityRenderLayer;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class InterpolatedEntityRenderer<T extends LivingEntity, S extends InterpolatedSkeleton>
extends EntityRenderer<T> {
    protected final SkeletonFactory<S> modelFactory;
    private final List<InterpolatedEntityRenderLayer<T, S>> layers = new ArrayList<InterpolatedEntityRenderLayer<T, S>>();

    protected InterpolatedEntityRenderer(EntityRendererProvider.Context pContext, SkeletonFactory<S> modelFactory, float shadowRadius) {
        super(pContext);
        this.modelFactory = modelFactory;
        this.shadowRadius = shadowRadius;
    }

    public void setupModelFactory(T parent) {
    }

    public final void createSkeleton(T parent) {
        this.setupModelFactory(parent);
        ((InterpolatedSkeletonParent)parent).setSkeleton((InterpolatedSkeleton)this.modelFactory.create());
    }

    public final boolean addLayer(InterpolatedEntityRenderLayer<T, S> layer) {
        return this.layers.add(layer);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        this.setupRotations(entity, poseStack, (float)((LivingEntity)entity).tickCount + partialTicks, partialTicks);
        Minecraft minecraft = Minecraft.getInstance();
        boolean invisible = entity.isInvisible();
        boolean isSpectatorTransparent = !invisible && !entity.isInvisibleTo((Player)minecraft.player);
        boolean glowing = minecraft.shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType(entity, invisible, isSpectatorTransparent, glowing);
        if (rendertype != null) {
            this.renderModel(entity, partialTicks, poseStack, buffer, packedLight);
        }
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)entity).getSkeleton();
        if (!entity.isSpectator()) {
            for (InterpolatedEntityRenderLayer<T, S> layer : this.layers) {
                if (skeleton == null) continue;
                layer.render(poseStack, buffer, packedLight, entity, skeleton, partialTicks);
            }
        }
        if (skeleton != null) {
            skeleton.renderDebug((InterpolatedSkeletonParent)entity, poseStack, buffer, partialTicks);
        }
        poseStack.popPose();
        super.render(entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void renderModel(T pEntity, float pPartialTicks, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight) {
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)pEntity).getSkeleton();
        if (skeleton == null) {
            return;
        }
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.getRenderType(pEntity));
        int packedOverlay = LivingEntityRenderer.getOverlayCoords(pEntity, (float)0.0f);
        skeleton.render(poseStack, vertexconsumer, pPackedLight, packedOverlay, pPartialTicks, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public abstract RenderType getRenderType(T var1);

    protected RenderType getRenderType(T pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        ResourceLocation resourcelocation = this.getTextureLocation((Entity)pLivingEntity);
        if (pTranslucent) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (pBodyVisible) {
            return this.getRenderType(pLivingEntity);
        }
        return pGlowing ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    protected void setupRotations(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pPartialTicks) {
        if (((LivingEntity)pEntityLiving).deathTime > 0) {
            float deathTime = ((float)((LivingEntity)pEntityLiving).deathTime + pPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathTime = Mth.sqrt((float)deathTime)) > 1.0f) {
                deathTime = 1.0f;
            }
            pMatrixStack.mulPose(Axis.ZP.rotationDegrees(deathTime * this.getFlipDegrees(pEntityLiving)));
        } else if (pEntityLiving.isAutoSpinAttack()) {
            pMatrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f - pEntityLiving.getXRot()));
            pMatrixStack.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)pEntityLiving).tickCount + pPartialTicks) * -75.0f));
        } else if (LivingEntityRenderer.isEntityUpsideDown(pEntityLiving)) {
            pMatrixStack.translate(0.0, (double)(pEntityLiving.getBbHeight() + 0.1f), 0.0);
            pMatrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
        if (pEntityLiving.isFullyFrozen()) {
            pMatrixStack.mulPose(Axis.YP.rotationDegrees(Mth.cos((float)((float)((LivingEntity)pEntityLiving).tickCount * 3.25f)) * (float)Math.PI * 0.4f));
        }
    }

    protected float getFlipDegrees(T entity) {
        return 90.0f;
    }

    public static void tick(List<InterpolatedSkeletonParent> entitiesToRender) {
        for (InterpolatedSkeletonParent interpolatedSkeletonParent : entitiesToRender) {
            AnimationProperties properties = new AnimationProperties();
            interpolatedSkeletonParent.getSkeleton().addAnimationProperties(properties, interpolatedSkeletonParent);
            interpolatedSkeletonParent.getSkeleton().tick(properties);
        }
    }
}

