/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.api.client.editor.Editor;
import foundry.veil.impl.client.editor.DeferredEditor;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.editor.ExampleEditor;
import foundry.veil.impl.client.editor.LightEditor;
import foundry.veil.impl.client.editor.OpenCLEditor;
import foundry.veil.impl.client.editor.PostEditor;
import foundry.veil.impl.client.editor.ShaderEditor;
import foundry.veil.impl.client.editor.TextureEditor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorManager
implements PreparableReloadListener {
    private final Map<Editor, ImBoolean> editors = new TreeMap<Editor, ImBoolean>(Comparator.comparing(Editor::getDisplayName));
    private boolean enabled;

    @ApiStatus.Internal
    public EditorManager(ReloadableResourceManager resourceManager) {
        this.add(new ExampleEditor());
        this.add(new PostEditor());
        this.add(new ShaderEditor());
        this.add(new TextureEditor());
        this.add(new OpenCLEditor());
        this.add(new DeviceInfoViewer());
        this.add(new DeferredEditor());
        this.add(new LightEditor());
        resourceManager.registerReloadListener((PreparableReloadListener)this);
    }

    @ApiStatus.Internal
    public void render() {
        ImBoolean enabled;
        Editor editor;
        if (!this.enabled) {
            return;
        }
        if (ImGui.beginMainMenuBar()) {
            if (ImGui.beginMenu("Editor")) {
                for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                    editor = entry.getKey();
                    enabled = entry.getValue();
                    ImGui.beginDisabled(!editor.isEnabled());
                    if (ImGui.menuItem(editor.getDisplayName(), null, enabled.get())) {
                        if (!enabled.get()) {
                            this.show(editor);
                        } else {
                            this.hide(editor);
                        }
                    }
                    ImGui.endDisabled();
                }
                ImGui.endMenu();
            }
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                if (!entry.getValue().get() || !editor.isMenuBarEnabled()) continue;
                ImGui.separator();
                ImGui.textColored(-5592406, editor.getDisplayName());
                editor.renderMenuBar();
            }
            ImGui.endMainMenuBar();
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            editor = entry.getKey();
            enabled = entry.getValue();
            if (!editor.isEnabled()) {
                enabled.set(false);
            }
            if (!enabled.get()) continue;
            editor.render();
        }
    }

    @ApiStatus.Internal
    public void renderLast() {
        if (!this.enabled) {
            return;
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!enabled.get()) continue;
            editor.renderLast();
        }
    }

    public void show(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && !enabled.get()) {
            editor.onShow();
            enabled.set(true);
        }
    }

    public void hide(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && enabled.get()) {
            editor.onHide();
            enabled.set(false);
        }
    }

    public boolean isVisible(Editor editor) {
        ImBoolean visible = this.editors.get(editor);
        return visible != null && visible.get();
    }

    public synchronized void add(Editor editor) {
        this.editors.computeIfAbsent(editor, unused -> new ImBoolean());
    }

    public synchronized void remove(Editor editor) {
        this.hide(editor);
        this.editors.remove(editor);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CompletableFuture<Void> reload(final @NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        PreparableReloadListener[] listeners = (PreparableReloadListener[])this.editors.keySet().stream().filter(editor -> editor instanceof PreparableReloadListener).toArray(PreparableReloadListener[]::new);
        if (listeners.length == 0) {
            return preparationBarrier.wait(null);
        }
        if (listeners.length == 1) {
            return listeners[0].reload(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
        }
        final CompletableFuture allComplete = new CompletableFuture();
        final HashSet<PreparableReloadListener> preparingListeners = new HashSet<PreparableReloadListener>(List.of(listeners));
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(listeners.length);
        for (final PreparableReloadListener listener : listeners) {
            PreparableReloadListener.PreparationBarrier barrier = new PreparableReloadListener.PreparationBarrier(){

                public <T> CompletableFuture<T> wait(T value) {
                    preparingListeners.remove(listener);
                    if (preparingListeners.isEmpty()) {
                        preparationBarrier.wait(null).thenRun(() -> allComplete.complete(Unit.INSTANCE));
                    }
                    return allComplete.thenApply(unused -> value);
                }
            };
            futures.add(listener.reload(barrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

