/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.color;

import foundry.veil.api.client.color.Color;

public class Filter {
    public static final IFilterType SEPIA = (color, value) -> {
        float r = color.getRed() * 0.393f + color.getGreen() * 0.769f + color.getBlue() * 0.189f;
        float g = color.getRed() * 0.349f + color.getGreen() * 0.686f + color.getBlue() * 0.168f;
        float b = color.getRed() * 0.272f + color.getGreen() * 0.534f + color.getBlue() * 0.131f;
        return new Color(r, g, b, color.getAlpha());
    };
    public static final IFilterType GRAYSCALE = (color, value) -> {
        float average = (color.getRed() + color.getGreen() + color.getBlue()) / 3.0f;
        return new Color(average, average, average, color.getAlpha());
    };

    public static Color apply(Color color, float value, IFilterType type) {
        return type.apply(color, value);
    }

    public static interface IFilterType {
        public Color apply(Color var1, float var2);
    }
}

