/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.color;

import net.minecraft.util.Mth;

public class Color {
    public static final Color WHITE = new Color(255, 255, 255, 255);
    public static final Color BLACK = new Color(0, 0, 0, 255);
    public static final Color RED = new Color(255, 0, 0, 255);
    public static final Color GREEN = new Color(0, 255, 0, 255);
    public static final Color BLUE = new Color(0, 0, 255, 255);
    public static final Color CLEAR = new Color(0, 0, 0, 0);
    public static final Color VANILLA_TOOLTIP_BACKGROUND = new Color(-267386864);
    public static final Color VANILLA_TOOLTIP_BORDER_TOP = new Color(0x505000FF);
    public static final Color VANILLA_TOOLTIP_BORDER_BOTTOM = new Color(1344798847);
    float r;
    float g;
    float b;
    float a;

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public static void tickRainbow(int ticks, float partialTick) {
    }

    public void lerp(Color other, float t) {
        this.r = Mth.lerp((float)t, (float)this.r, (float)other.r);
        this.g = Mth.lerp((float)t, (float)this.g, (float)other.g);
        this.b = Mth.lerp((float)t, (float)this.b, (float)other.b);
        this.a = Mth.lerp((float)t, (float)this.a, (float)other.a);
    }

    public void setHue(float hue) {
        float h = hue * 6.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = 1.0f - this.a;
        float q = 1.0f - f * this.a;
        float t = 1.0f - (1.0f - f) * this.a;
        switch (i) {
            case 0: {
                this.r = this.a;
                this.g = t;
                this.b = p;
                break;
            }
            case 1: {
                this.r = q;
                this.g = this.a;
                this.b = p;
                break;
            }
            case 2: {
                this.r = p;
                this.g = this.a;
                this.b = t;
                break;
            }
            case 3: {
                this.r = p;
                this.g = q;
                this.b = this.a;
                break;
            }
            case 4: {
                this.r = t;
                this.g = p;
                this.b = this.a;
                break;
            }
            case 5: {
                this.r = this.a;
                this.g = p;
                this.b = q;
            }
        }
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int hex) {
        this(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, hex >> 24 & 0xFF);
    }

    public Color(int hex, boolean hasAlpha) {
        this(hex);
        if (!hasAlpha) {
            this.a = 1.0f;
        }
    }

    public Color() {
        this(0, 0, 0, 0);
    }

    public Color(String hex) {
        this(Integer.parseInt(hex, 16));
    }

    public float getRed() {
        return this.r;
    }

    public static Color of(int col) {
        return BLACK.add(col);
    }

    public Color add(int col) {
        this.r += (float)(col >> 16 & 0xFF);
        this.g += (float)(col >> 8 & 0xFF);
        this.b += (float)(col & 0xFF);
        this.a += (float)(col >> 24 & 0xFF);
        return this;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }

    public int getRedInt() {
        return (int)(this.r * 255.0f);
    }

    public int getGreenInt() {
        return (int)(this.g * 255.0f);
    }

    public int getBlueInt() {
        return (int)(this.b * 255.0f);
    }

    public int getAlphaInt() {
        return (int)(this.a * 255.0f);
    }

    public int getHex() {
        return this.getAlphaInt() << 24 | this.getRedInt() << 16 | this.getGreenInt() << 8 | this.getBlueInt();
    }

    public String getHexStr() {
        return String.format("%08X", this.getHex());
    }

    public void mix(Color color, float amount) {
        this.r = this.r * (1.0f - amount) + color.r * amount;
        this.g = this.g * (1.0f - amount) + color.g * amount;
        this.b = this.b * (1.0f - amount) + color.b * amount;
        this.a = this.a * (1.0f - amount) + color.a * amount;
    }

    public Color mixCopy(Color color, float amount) {
        Color newColor = new Color(this.r, this.g, this.b, this.a);
        newColor.mix(color, amount);
        return newColor;
    }

    public void lighten(float amount) {
        this.mix(WHITE, amount);
    }

    public Color lightenCopy(float amount) {
        return this.mixCopy(WHITE, amount);
    }

    public void darken(float amount) {
        this.mix(BLACK, amount);
    }

    public Color darkenCopy(float amount) {
        return this.mixCopy(BLACK, amount);
    }

    public void saturate(float amount) {
        float gray = (this.r + this.g + this.b) / 3.0f;
        this.r = this.r * (1.0f - amount) + gray * amount;
        this.g = this.g * (1.0f - amount) + gray * amount;
        this.b = this.b * (1.0f - amount) + gray * amount;
    }

    public Color saturateCopy(float amount) {
        Color newColor = new Color(this.r, this.g, this.b, this.a);
        newColor.saturate(amount);
        return newColor;
    }

    public Color multiply(float r, float g, float b, float a) {
        return new Color(this.r * r, this.g * g, this.b * b, this.a * a);
    }

    public Color multiply(int col) {
        return this.multiply(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, col >> 24 & 0xFF);
    }

    public void desaturate(float amount) {
        this.saturate(-amount);
    }

    public Color desaturateCopy(float amount) {
        return this.saturateCopy(-amount);
    }

    public void invert() {
        this.r = 1.0f - this.r;
        this.g = 1.0f - this.g;
        this.b = 1.0f - this.b;
    }

    public Color invertCopy() {
        Color newColor = new Color(this.r, this.g, this.b, this.a);
        newColor.invert();
        return newColor;
    }

    public int getRGB() {
        return this.getRedInt() << 16 | this.getGreenInt() << 8 | this.getBlueInt();
    }

    public int getRGBA() {
        return this.getRedInt() << 24 | this.getGreenInt() << 16 | this.getBlueInt() << 8 | this.getAlphaInt();
    }
}

