/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.compiler;

import foundry.veil.lib.asm.tree.MethodNode;
import gg.moonflower.molangcompiler.api.exception.MolangSyntaxException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record MolangBytecodeEnvironment(Map<String, Integer> variables, Set<String> modifiedVariables, boolean optimize) {
    public MolangBytecodeEnvironment(MolangBytecodeEnvironment environment) {
        this(new HashMap<String, Integer>(environment.variables), new LinkedHashSet<String>(), environment.optimize);
    }

    public MolangBytecodeEnvironment(int flags) {
        this(new HashMap<String, Integer>(), new LinkedHashSet<String>(), (flags & 1) > 0);
    }

    public void reset() {
        this.variables.clear();
        this.modifiedVariables.clear();
    }

    public int loadVariable(MethodNode method, String object, String name) {
        String key = object + "." + name;
        Integer index = this.variables.get(key);
        if (index != null) {
            return index;
        }
        int objectIndex = this.getObjectIndex(method, object);
        method.visitVarInsn(25, objectIndex);
        method.visitLdcInsn(name);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/object/MolangObject", "get", "(Ljava/lang/String;)Lgg/moonflower/molangcompiler/api/MolangExpression;", true);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/MolangExpression", "resolve", "(Lgg/moonflower/molangcompiler/api/MolangEnvironment;)F", true);
        index = this.allocateVariable(key);
        method.visitVarInsn(56, index);
        return index;
    }

    public int allocateVariable(String name) {
        Integer index = this.variables.get(name);
        if (index != null) {
            return index;
        }
        index = this.variables.size() + 2;
        this.variables.put(name, index);
        return index;
    }

    public int getObjectIndex(MethodNode method, String object) {
        Integer index = this.variables.get(object);
        if (index != null) {
            return index;
        }
        index = this.allocateVariable(object);
        method.visitVarInsn(25, 1);
        method.visitLdcInsn(object);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/MolangEnvironment", "get", "(Ljava/lang/String;)Lgg/moonflower/molangcompiler/api/object/MolangObject;", true);
        method.visitVarInsn(58, index);
        return index;
    }

    public void loadObjectHas(MethodNode method, String object, String name) {
        if ("temp".equals(object)) {
            method.visitLdcInsn(this.variables.containsKey("temp." + name));
            return;
        }
        String key = object + "." + name + "$has";
        Integer objectHasIndex = this.variables.get(key);
        if (objectHasIndex != null) {
            method.visitVarInsn(21, objectHasIndex);
            return;
        }
        objectHasIndex = this.allocateVariable(key);
        int objectIndex = this.getObjectIndex(method, object);
        method.visitVarInsn(25, objectIndex);
        method.visitLdcInsn(name);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/object/MolangObject", "has", "(Ljava/lang/String;)Z", true);
        method.visitInsn(89);
        method.visitVarInsn(54, objectHasIndex);
    }

    public void markDirty(String object, String name) {
        if ("temp".equals(object)) {
            return;
        }
        this.modifiedVariables.add(object + "." + name);
    }

    public void writeModifiedVariables(MethodNode method) throws MolangSyntaxException {
        for (String name : this.modifiedVariables) {
            Integer index = this.variables.get(name);
            if (index == null) {
                throw new MolangSyntaxException("Unknown variable index: " + name);
            }
            String[] parts = name.split("\\.", 2);
            if (parts.length != 2) {
                throw new MolangSyntaxException("Expected 2 variable parts for " + name + ", got " + parts.length);
            }
            int objectIndex = this.getObjectIndex(method, parts[0]);
            method.visitVarInsn(25, objectIndex);
            method.visitLdcInsn(parts[1]);
            method.visitVarInsn(23, index);
            method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "setValue", "(Lgg/moonflower/molangcompiler/api/object/MolangObject;Ljava/lang/String;F)V", false);
        }
        this.modifiedVariables.clear();
    }
}

