/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api.object;

import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.object.MolangObject;
import gg.moonflower.molangcompiler.core.node.MolangFunctionNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class MolangLibrary
implements MolangObject {
    private final Map<String, MolangExpression> values = new HashMap<String, MolangExpression>();

    public MolangLibrary() {
        this.populate(this.values::put);
    }

    protected abstract void populate(BiConsumer<String, MolangExpression> var1);

    protected abstract String getName();

    @Override
    public void set(String name, MolangExpression value) throws MolangRuntimeException {
        throw new MolangRuntimeException("Cannot set values to " + this.getName());
    }

    @Override
    public void remove(String name) throws MolangRuntimeException {
        throw new MolangRuntimeException("Cannot remove values from " + this.getName());
    }

    @Override
    public MolangExpression get(String name) throws MolangRuntimeException {
        MolangExpression expression = this.values.get(name);
        if (expression != null) {
            return expression;
        }
        throw new MolangRuntimeException("Unknown MoLang expression: " + name);
    }

    @Override
    public boolean has(String name) {
        return this.values.containsKey(name);
    }

    @Override
    public Collection<String> getKeys() {
        return this.values.keySet();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName()).append('\n');
        for (Map.Entry<String, MolangExpression> entry : this.values.entrySet()) {
            builder.append('\t').append(entry.getKey());
            if (entry.getValue() instanceof MolangFunctionNode) {
                builder.append("()");
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

