/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters.modules.particle.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.quasar.client.particle.ParticleModuleSet;
import foundry.veil.quasar.data.module.ModuleType;
import foundry.veil.quasar.data.module.ParticleModuleData;
import foundry.veil.quasar.util.CodecUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record InitRandomRotationModuleData(Vector3fc minDegrees, Vector3fc maxDegrees) implements ParticleModuleData
{
    public static final Codec<InitRandomRotationModuleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtil.VECTOR3F_CODEC.fieldOf("min_degrees").forGetter(InitRandomRotationModuleData::minDegrees), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("max_degrees").forGetter(InitRandomRotationModuleData::maxDegrees)).apply((Applicative)instance, InitRandomRotationModuleData::new));

    @Override
    public void addModules(ParticleModuleSet.Builder builder) {
        builder.addModule(particle -> {
            Vector3f rot = this.minDegrees.lerp(this.maxDegrees, particle.getRandomSource().method_43057(), new Vector3f());
            particle.getRotation().add((float)Math.toRadians(rot.x), (float)Math.toRadians(rot.y), (float)Math.toRadians(rot.z));
        });
    }

    @Override
    public ModuleType<?> getType() {
        return ModuleType.INIT_RANDOM_ROTATION;
    }
}

