/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters.modules.particle.force;

import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.data.module.force.VortexForceData;
import foundry.veil.quasar.emitters.modules.particle.ForceParticleModule;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VortexForceModule
implements ForceParticleModule {
    private final VortexForceData data;
    private final float rangeSq;
    private final Vector3d normalizedVortexAxis;
    private final Vector3d temp;
    private final Vector3d dot;

    public VortexForceModule(VortexForceData data) {
        this.data = data;
        this.rangeSq = data.range() * data.range();
        this.normalizedVortexAxis = data.vortexAxis().normalize(new Vector3d());
        this.temp = new Vector3d();
        this.dot = new Vector3d();
    }

    @Override
    public void applyForce(QuasarParticle particle) {
        Vector3d diff = this.data.vortexCenter().sub((Vector3dc)particle.getPosition(), this.temp);
        double distanceSq = diff.lengthSquared();
        if (distanceSq >= (double)this.rangeSq) {
            return;
        }
        Vector3d particleToCenterOnAxis = diff.sub((Vector3dc)this.data.vortexAxis().mul(diff.dot((Vector3dc)this.normalizedVortexAxis), this.dot));
        particleToCenterOnAxis.normalize();
        particleToCenterOnAxis.cross((Vector3dc)this.normalizedVortexAxis).mul((double)this.data.strength());
        particle.getVelocity().add((Vector3dc)particleToCenterOnAxis);
    }
}

