/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.data.module.render;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.molang.MolangExpressionCodec;
import foundry.veil.quasar.client.particle.ParticleModuleSet;
import foundry.veil.quasar.data.module.ModuleType;
import foundry.veil.quasar.data.module.ParticleModuleData;
import foundry.veil.quasar.util.ColorGradient;
import gg.moonflower.molangcompiler.api.MolangExpression;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4fc;

public record ColorParticleModuleData(ColorGradient gradient, @Nullable MolangExpression interpolant) implements ParticleModuleData
{
    public static final Codec<ColorParticleModuleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColorGradient.CODEC.fieldOf("gradient").forGetter(ColorParticleModuleData::gradient), (App)MolangExpressionCodec.CODEC.optionalFieldOf("interpolant").forGetter(data -> Optional.ofNullable(data.interpolant()))).apply((Applicative)instance, (gradient, interpolant) -> new ColorParticleModuleData((ColorGradient)gradient, interpolant.orElse(null))));

    @Override
    public void addModules(ParticleModuleSet.Builder builder) {
        if (this.gradient.isConstant() || this.interpolant == null) {
            builder.addModule(particle -> particle.getRenderData().setColor((Vector4fc)this.gradient.getColor(0.0f)));
        } else {
            builder.addModule((particle, partialTicks) -> {
                float percentage = particle.getEnvironment().safeResolve(this.interpolant);
                particle.getRenderData().setColor((Vector4fc)this.gradient.getColor(percentage));
            });
        }
    }

    @Override
    public ModuleType<?> getType() {
        return ModuleType.INIT_COLOR;
    }
}

