/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.data;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import foundry.veil.Veil;
import foundry.veil.mixin.client.quasar.RegistryDataAccessor;
import foundry.veil.mixin.client.quasar.RegistryDataLoaderAccessor;
import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.data.EmitterShapeSettings;
import foundry.veil.quasar.data.ParticleEmitterData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.data.module.ParticleModuleData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7655;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public final class QuasarParticles {
    public static final class_5321<class_2378<ParticleModuleData>> INIT_MODULES = QuasarParticles.createRegistryKey("quasar/modules/init");
    public static final class_5321<class_2378<ParticleModuleData>> UPDATE_MODULES = QuasarParticles.createRegistryKey("quasar/modules/update");
    public static final class_5321<class_2378<ParticleModuleData>> RENDER_MODULES = QuasarParticles.createRegistryKey("quasar/modules/render");
    public static final class_5321<class_2378<QuasarParticleData>> PARTICLE_DATA = QuasarParticles.createRegistryKey("quasar/modules/particle_data");
    public static final class_5321<class_2378<ParticleSettings>> PARTICLE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/particle");
    public static final class_5321<class_2378<EmitterShapeSettings>> EMITTER_SHAPE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/shape");
    public static final class_5321<class_2378<ParticleEmitterData>> EMITTER = QuasarParticles.createRegistryKey("quasar/emitters");
    private static final SuggestionProvider<?> EMITTER_SUGGESTION_PROVIDER = (unused, builder) -> class_2172.method_9270((Iterable)QuasarParticles.registryAccess().method_30530(EMITTER).method_10235(), (SuggestionsBuilder)builder);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<class_7655.class_7657<?>> REGISTRIES = List.of(new class_7655.class_7657(INIT_MODULES, ParticleModuleData.INIT_DIRECT_CODEC), new class_7655.class_7657(UPDATE_MODULES, ParticleModuleData.UPDATE_DIRECT_CODEC), new class_7655.class_7657(RENDER_MODULES, ParticleModuleData.RENDER_DIRECT_CODEC), new class_7655.class_7657(PARTICLE_DATA, QuasarParticleData.DIRECT_CODEC), new class_7655.class_7657(PARTICLE_SETTINGS, ParticleSettings.DIRECT_CODEC), new class_7655.class_7657(EMITTER_SHAPE_SETTINGS, EmitterShapeSettings.DIRECT_CODEC), new class_7655.class_7657(EMITTER, ParticleEmitterData.DIRECT_CODEC));
    private static class_5455 registryAccess = class_5455.field_40585;

    private QuasarParticles() {
    }

    private static <T> class_5321<class_2378<T>> createRegistryKey(String name) {
        return class_5321.method_29180((class_2960)Veil.veilPath(name));
    }

    public static <T extends class_2172> SuggestionProvider<T> emitterSuggestionProvider() {
        return EMITTER_SUGGESTION_PROVIDER;
    }

    public static class_5455 registryAccess() {
        return registryAccess;
    }

    @ApiStatus.Internal
    public static class Reloader
    extends class_4080<Preparations> {
        protected Preparations prepare(class_3300 resourceManager, class_3695 profilerFiller) {
            HashMap errors = new HashMap();
            List<Pair<class_2385<?>, class_7655.class_7656>> loaders = REGISTRIES.stream().map(data -> ((RegistryDataAccessor)data).invokeCreate(Lifecycle.stable(), errors)).toList();
            class_6903.class_7863 lookup = RegistryDataLoaderAccessor.invokeCreateContext((class_5455)class_5455.field_40585, loaders);
            loaders.forEach(pair -> ((class_7655.class_7656)pair.getSecond()).load(resourceManager, lookup));
            loaders.forEach(pair -> {
                class_2378 registry = (class_2378)pair.getFirst();
                try {
                    registry.method_40276();
                }
                catch (Exception e) {
                    errors.put(registry.method_30517(), e);
                }
            });
            class_5455.class_6890 registryAccess = new class_5455.class_6891(loaders.stream().map(Pair::getFirst).toList()).method_40316();
            return new Preparations((class_5455)registryAccess, errors);
        }

        protected void apply(Preparations preparations, class_3300 resourceManager, class_3695 profilerFiller) {
            registryAccess = preparations.registryAccess;
            QuasarParticle.clearErrors();
            Reloader.printErrors(preparations.errors);
            LOGGER.info("Loaded {} quasar particles", (Object)registryAccess.method_30530(EMITTER).method_10204());
        }

        private static void printErrors(Map<class_5321<?>, Exception> errors) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Map<class_2960, Map<class_2960, Exception>> sortedErrors = errors.entrySet().stream().collect(Collectors.groupingBy(entry -> ((class_5321)entry.getKey()).method_41185(), Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue)));
            sortedErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(registryError -> {
                printWriter.printf("%n> %d Errors in registry %s:", ((Map)registryError.getValue()).size(), registryError.getKey());
                ((Map)registryError.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(elementError -> {
                    Throwable error = (Throwable)elementError.getValue();
                    while (error.getCause() != null) {
                        error = error.getCause();
                    }
                    printWriter.printf("%n>> Error in element %s: %s", elementError.getKey(), error.getMessage());
                });
            });
            printWriter.flush();
            LOGGER.error("Quasar registry loading errors:{}", (Object)stringWriter);
        }

        public record Preparations(class_5455 registryAccess, Map<class_5321<?>, Exception> errors) {
        }
    }
}

