/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import foundry.veil.Veil;
import foundry.veil.quasar.ParticleEmitter;
import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.client.particle.SpriteData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.emitters.modules.particle.CollisionParticleModule;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Deprecated
public class QuasarVanillaParticle
extends class_703 {
    public static final class_243[] PLANE = new class_243[]{new class_243(-1.0, 1.0, 0.0), new class_243(1.0, 1.0, 0.0), new class_243(1.0, -1.0, 0.0), new class_243(-1.0, -1.0, 0.0)};
    public static final class_243[] CUBE = new class_243[]{new class_243(1.0, 1.0, -1.0), new class_243(1.0, 1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(1.0, 1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, 1.0, -1.0), new class_243(1.0, -1.0, -1.0)};
    private static final class_2960 BLANK = Veil.veilPath("textures/special/blank.png");
    public boolean shouldCollide = false;
    protected boolean emissive = true;
    private boolean stoppedByCollision;
    private final QuasarParticle particle;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = class_3532.method_33723((double)100.0);

    public QuasarVanillaParticle(QuasarParticleData data, ParticleSettings particleSettings, ParticleEmitter parentEmitter, class_638 world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_3852 = motionX;
        this.field_3869 = motionY;
        this.field_3850 = motionZ;
        this.particle = null;
        float scale = this.particle.getRadius();
        float width = this.field_3849 / 2.0f;
        float height = this.field_3867;
        this.method_3067(new class_238(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width));
        this.method_3080(scale * 0.5f, scale * 0.5f);
    }

    public void method_3070() {
        QuasarParticleData data;
        this.particle.tick();
        Vector3d velocity = this.particle.getVelocity();
        Vector3f rotation = this.particle.getRotation();
        if (this.stoppedByCollision || this.field_3845) {
            for (CollisionParticleModule collisionParticle : this.particle.getModules().getCollisionModules()) {
                collisionParticle.collide(this.particle);
            }
        }
        if (!this.shouldCollide && this.particle.getModules().getCollisionModules().length > 0) {
            this.shouldCollide = true;
        }
        if ((data = this.particle.getData()).faceVelocity()) {
            Vector3d normalizedMotion = velocity.normalize(new Vector3d());
            rotation.x = (float)Math.atan2(normalizedMotion.y, Math.sqrt(normalizedMotion.x * normalizedMotion.x + normalizedMotion.z * normalizedMotion.z));
            rotation.y = (float)Math.atan2(normalizedMotion.x, normalizedMotion.z);
            if (data.renderStyle() == RenderStyle.BILLBOARD) {
                rotation.y += 1.5707964f;
            }
        }
        this.method_3069(velocity.x, velocity.y, velocity.z);
        if (this.shouldCollide) {
            List entities = this.field_3851.method_8335(null, this.method_3064().method_1014((double)(this.particle.getRadius() * 2.0f)));
            for (class_1297 entity : entities) {
                class_1309 livingEntity;
                if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_5805()) continue;
                this.stoppedByCollision = true;
            }
        }
        if (this.particle.isRemoved()) {
            this.method_3085();
        }
    }

    public void method_3085() {
        this.particle.onRemove();
        super.method_3085();
    }

    public void method_3069(double pX, double pY, double pZ) {
        if (!this.stoppedByCollision) {
            double d0 = pX;
            double d1 = pY;
            double d2 = pZ;
            if (this.shouldCollide && this.field_3862 && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                class_243 vec3 = class_1297.method_20736(null, (class_243)new class_243(pX, pY, pZ), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
                pX = vec3.field_1352;
                pY = vec3.field_1351;
                pZ = vec3.field_1350;
            }
            if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
                this.method_3067(this.method_3064().method_989(pX, pY, pZ));
                this.method_3072();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
                this.stoppedByCollision = this.shouldCollide;
            }
            boolean bl = this.field_3845 = d1 != pY && d1 < 0.0;
            if (d0 != pX) {
                this.particle.getVelocity().x = 0.0;
                this.stoppedByCollision = true;
            }
            if (d2 != pZ) {
                this.particle.getVelocity().z = 0.0;
                this.stoppedByCollision = true;
            }
        }
    }

    public void method_3063(double x, double y, double z) {
        if (this.particle == null) {
            return;
        }
        this.particle.getPosition().set(x, y, z);
        float width = this.field_3849 / 2.0f;
        float height = this.field_3867;
        this.method_3067(new class_238(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width));
    }

    protected void method_3072() {
        class_238 box = this.method_3064();
        this.particle.getPosition().set((box.field_1323 + box.field_1320) / 2.0, box.field_1322, (box.field_1321 + box.field_1324) / 2.0);
    }

    protected int method_3068(float $$0) {
        class_2338 pos = this.particle.getBlockPosition();
        return this.field_3851.method_22340(pos) ? class_761.method_23794((class_1920)this.field_3851, (class_2338)pos) : 0;
    }

    public void method_3074(class_4588 builder, class_4184 camera, float partialTicks) {
        RenderData renderData = this.particle.getRenderData();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        builder = bufferBuilder;
        this.particle.render(partialTicks);
        class_243 projectedView = camera.method_19326();
        Vector3dc renderPosition = renderData.getRenderPosition();
        Vector3f renderOffset = new Vector3f((float)(renderPosition.x() - projectedView.method_10216()), (float)(renderPosition.y() - projectedView.method_10214()), (float)(renderPosition.z() - projectedView.method_10215()));
        Vector3d motionDirection = this.particle.getVelocity().normalize(new Vector3d());
        this.particle.getData().renderStyle().render(new class_4587(), this.particle, renderData, (Vector3fc)renderOffset, (Vector3dc)motionDirection, this.method_3068(partialTicks), builder, 1.0, partialTicks);
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public class_1937 getLevel() {
        return this.field_3851;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RenderStyle implements RenderFunction
    {
        CUBE{

            @Override
            public void render(class_4587 poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, Vector3dc motionDirection, int light, class_4588 builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                Vector3fc rotation = renderData.getRenderRotation();
                for (int i = 0; i < 6; ++i) {
                    class_243[] faceVerts = new class_243[]{QuasarVanillaParticle.CUBE[i * 4], QuasarVanillaParticle.CUBE[i * 4 + 1], QuasarVanillaParticle.CUBE[i * 4 + 2], QuasarVanillaParticle.CUBE[i * 4 + 3]};
                    class_1058 sprite = renderData.getAtlasSprite();
                    if (sprite != null) {
                        builder = sprite.method_24108(builder);
                    }
                    for (int j = 0; j < 4; ++j) {
                        Vector3f vec = faceVerts[j].method_46409().mul(-1.0f);
                        QuasarParticleData data = particle.getData();
                        if (vec.z < 0.0f && data.velocityStretchFactor() != 0.0f) {
                            vec.z *= 1.0f + data.velocityStretchFactor();
                        }
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z()).mul((float)((double)renderData.getRenderScale() * ageModifier)).add(renderOffset);
                        builder.method_22918(matrix4f, vec.x, vec.y, vec.z);
                        builder.method_22913((float)j / 2.0f, (float)(j % 2));
                        builder.method_22915(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                        builder.method_22916(light);
                        builder.method_1344();
                    }
                }
            }
        }
        ,
        BILLBOARD{

            @Override
            public void render(class_4587 poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, Vector3dc motionDirection, int light, class_4588 builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                Vector3fc rotation = renderData.getRenderRotation();
                class_243[] faceVerts = new class_243[]{PLANE[0], PLANE[1], PLANE[2], PLANE[3]};
                Quaternionf faceCameraRotation = class_310.method_1551().method_1561().method_24197();
                SpriteData spriteData = renderData.getSpriteData();
                class_1058 sprite = renderData.getAtlasSprite();
                if (sprite != null) {
                    builder = sprite.method_24108(builder);
                }
                for (int j = 0; j < 4; ++j) {
                    float v;
                    float u;
                    Vector3f vec = faceVerts[j].method_46409().mul(-1.0f);
                    if (particle.getData().velocityStretchFactor() > 0.0f) {
                        vec.set(vec.x * (1.0f + particle.getData().velocityStretchFactor()), vec.y, vec.z);
                    }
                    if (particle.getData().faceVelocity()) {
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z());
                    }
                    faceCameraRotation.transform(vec).mul((float)((double)renderData.getRenderScale() * ageModifier)).add(renderOffset);
                    if (j == 0) {
                        u = 0.0f;
                        v = 0.0f;
                    } else if (j == 1) {
                        u = 1.0f;
                        v = 0.0f;
                    } else if (j == 2) {
                        u = 1.0f;
                        v = 1.0f;
                    } else {
                        u = 0.0f;
                        v = 1.0f;
                    }
                    if (spriteData != null) {
                        int spritesheetRows = spriteData.frameHeight();
                        int spritesheetColumns = spriteData.frameWidth();
                        int spriteCount = spriteData.frameCount();
                        float animationSpeed = spriteData.frameTime();
                        int frameIndex = (int)(renderData.getRenderAge() / animationSpeed);
                        int frameIndexInSpritesheet = frameIndex % spriteCount;
                        int frameRow = frameIndexInSpritesheet / spritesheetColumns;
                        int frameColumn = frameIndexInSpritesheet % spritesheetColumns;
                        u *= 1.0f / (float)spritesheetColumns + (float)frameColumn * (1.0f / (float)spritesheetColumns);
                        v *= 1.0f / (float)spritesheetRows + (float)frameRow * (1.0f / (float)spritesheetRows);
                    }
                    builder.method_22918(matrix4f, vec.x, vec.y, vec.z);
                    builder.method_22913(u, v);
                    builder.method_22915(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                    builder.method_22916(light);
                    builder.method_1344();
                }
            }
        };

    }

    @FunctionalInterface
    static interface RenderFunction {
        public void render(class_4587 var1, QuasarParticle var2, RenderData var3, Vector3fc var4, Vector3dc var5, int var6, class_4588 var7, double var8, float var10);
    }
}

