/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import com.mojang.logging.LogUtils;
import foundry.veil.quasar.ParticleEmitter;
import foundry.veil.quasar.client.particle.ParticleModuleSet;
import foundry.veil.quasar.client.particle.QuasarVanillaParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.data.module.ParticleModuleData;
import foundry.veil.quasar.emitters.modules.particle.CollisionParticleModule;
import foundry.veil.quasar.emitters.modules.particle.InitParticleModule;
import foundry.veil.quasar.emitters.modules.particle.ParticleModule;
import foundry.veil.quasar.emitters.modules.particle.RenderParticleModule;
import foundry.veil.quasar.emitters.modules.particle.UpdateParticleModule;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_761;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public class QuasarParticle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = class_3532.method_33723((double)100.0);
    private static final Set<class_6880<ParticleModuleData>> REPORTED_MODULES = new HashSet<class_6880<ParticleModuleData>>();
    private final class_638 level;
    private final class_5819 randomSource;
    private final QuasarParticleData data;
    private final ParticleSettings settings;
    private final ParticleEmitter parent;
    private final ParticleModuleSet modules;
    private final Vector3d position;
    private final Vector3d velocity;
    private final Vector3f rotation;
    private final class_2338.class_2339 blockPosition;
    private final boolean hasCollision;
    private float radius;
    private final int lifetime;
    private int age;
    private class_238 boundingBox;
    private boolean stoppedByCollision;
    private final MolangRuntime environment;
    private final RenderData renderData;

    public QuasarParticle(class_638 level, class_5819 randomSource, QuasarParticleData data, ParticleSettings settings, ParticleEmitter parent) {
        this.level = level;
        this.randomSource = randomSource;
        this.data = data;
        this.settings = settings;
        this.parent = parent;
        this.modules = QuasarParticle.createModuleSet(data);
        this.position = new Vector3d();
        this.velocity = new Vector3d();
        this.rotation = new Vector3f();
        this.blockPosition = new class_2338.class_2339();
        this.hasCollision = this.modules.getCollisionModules().length > 0;
        this.radius = settings.particleSize(this.randomSource);
        this.lifetime = settings.particleLifetime(this.randomSource);
        this.age = 0;
        this.renderData = new RenderData();
        this.environment = (MolangRuntime)MolangRuntime.runtime().setQuery("x", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().x()))).setQuery("y", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().y()))).setQuery("z", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().z()))).setQuery("velX", MolangExpression.of(() -> Float.valueOf((float)this.velocity.x()))).setQuery("velY", MolangExpression.of(() -> Float.valueOf((float)this.velocity.y()))).setQuery("velZ", MolangExpression.of(() -> Float.valueOf((float)this.velocity.z()))).setQuery("speedSq", MolangExpression.of(() -> Float.valueOf((float)this.velocity.lengthSquared()))).setQuery("speed", MolangExpression.of(() -> Float.valueOf((float)this.velocity.length()))).setQuery("xRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().x())))).setQuery("yRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().y())))).setQuery("zRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().z())))).setQuery("scale", MolangExpression.of(this.renderData::getRenderScale)).setQuery("age", MolangExpression.of(this.renderData::getRenderAge)).setQuery("agePercent", MolangExpression.of(this.renderData::getAgePercent)).setQuery("lifetime", this.lifetime).create();
    }

    private static ParticleModuleSet createModuleSet(QuasarParticleData data) {
        ParticleModuleSet.Builder builder = ParticleModuleSet.builder();
        data.allModules().forEach(module -> {
            if (!module.method_40227()) {
                if (REPORTED_MODULES.add((class_6880<ParticleModuleData>)module)) {
                    String string;
                    if (module instanceof class_6880.class_6883) {
                        class_6880.class_6883 ref = (class_6880.class_6883)module;
                        string = ref.method_40237().method_29177();
                    } else {
                        string = module.getClass().getName();
                    }
                    LOGGER.error("Unknown module: {}", (Object)string);
                }
                return;
            }
            ((ParticleModuleData)module.comp_349()).addModules(builder);
        });
        return builder.build();
    }

    private void move(double dx, double dy, double dz) {
        if (this.stoppedByCollision || dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        class_238 box = this.getBoundingBox();
        double d0 = dx;
        double d1 = dy;
        double d2 = dz;
        if (this.hasCollision && dx * dx + dy * dy + dz * dz < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            class_243 vec3 = class_1297.method_20736(null, (class_243)new class_243(dx, dy, dz), (class_238)box, (class_1937)this.level, List.of());
            dx = vec3.field_1352;
            dy = vec3.field_1351;
            dz = vec3.field_1350;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.position.add(dx, dy, dz);
            this.updateBoundingBox();
        }
        if (!this.hasCollision) {
            return;
        }
        List entities = this.level.method_8335(null, box);
        for (class_1297 entity : entities) {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_5805()) continue;
            this.stoppedByCollision = true;
            break;
        }
        if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
            this.stoppedByCollision = true;
        }
        if (d0 != dx) {
            this.velocity.x = 0.0;
            this.stoppedByCollision = true;
        }
        if (d1 != dy) {
            this.velocity.y = 0.0;
            this.stoppedByCollision = true;
        }
        if (d2 != dz) {
            this.velocity.z = 0.0;
            this.stoppedByCollision = true;
        }
        if (this.stoppedByCollision) {
            for (CollisionParticleModule collisionParticle : this.modules.getCollisionModules()) {
                collisionParticle.collide(this);
            }
        }
    }

    private void updateBoundingBox() {
        double r = (double)this.radius / 2.0;
        this.boundingBox = new class_238(this.position.x - r, this.position.y - r, this.position.z - r, this.position.x + r, this.position.y + r, this.position.z + r);
    }

    @ApiStatus.Internal
    public void init() {
        for (InitParticleModule initModule : this.modules.getInitModules()) {
            initModule.init(this);
        }
        this.renderData.tick((Vector3dc)this.position, (Vector3fc)this.rotation, this.radius);
        this.updateBoundingBox();
    }

    @ApiStatus.Internal
    public static void clearErrors() {
        REPORTED_MODULES.clear();
    }

    @ApiStatus.Internal
    public void tick() {
        this.renderData.tick((Vector3dc)this.position, (Vector3fc)this.rotation, this.radius);
        for (UpdateParticleModule updateParticleModule : this.modules.getUpdateModules()) {
            updateParticleModule.update(this);
        }
        for (ParticleModule particleModule : this.modules.getForceModules()) {
            particleModule.applyForce(this);
        }
        if (this.data.faceVelocity()) {
            Vector3d normalizedMotion = this.velocity.normalize(new Vector3d());
            this.rotation.x = (float)Math.atan2(normalizedMotion.y, Math.sqrt(normalizedMotion.x * normalizedMotion.x + normalizedMotion.z * normalizedMotion.z));
            this.rotation.y = (float)Math.atan2(normalizedMotion.x, normalizedMotion.z);
            if (this.data.renderStyle() == QuasarVanillaParticle.RenderStyle.BILLBOARD) {
                this.rotation.y += 1.5707964f;
            }
        }
        this.move(this.velocity.x, this.velocity.y, this.velocity.z);
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
    }

    @ApiStatus.Internal
    public void render(float partialTicks) {
        for (RenderParticleModule renderModule : this.modules.getRenderModules()) {
            renderModule.render(this, partialTicks);
        }
        this.renderData.render((Vector3dc)this.position, (Vector3fc)this.rotation, this.radius, this.age, this.lifetime, partialTicks);
    }

    @ApiStatus.Internal
    public void onRemove() {
        for (ParticleModule module : this.modules.getAllModules()) {
            module.onRemove();
        }
    }

    public void remove() {
        this.age = Integer.MAX_VALUE;
    }

    public boolean isRemoved() {
        return this.age == Integer.MAX_VALUE;
    }

    public class_638 getLevel() {
        return this.level;
    }

    public class_5819 getRandomSource() {
        return this.randomSource;
    }

    public QuasarParticleData getData() {
        return this.data;
    }

    public ParticleSettings getSettings() {
        return this.settings;
    }

    public ParticleEmitter getParent() {
        return this.parent;
    }

    public ParticleModuleSet getModules() {
        return this.modules;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public class_2338 getBlockPosition() {
        return this.blockPosition.method_10102(this.position.x, this.position.y, this.position.z);
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public class_2680 getBlockStateInOrUnder() {
        class_2680 in = this.level.method_8320(class_2338.method_49637((double)this.position.x, (double)(this.position.y + 0.5), (double)this.position.z));
        if (!in.method_26215()) {
            return in;
        }
        return this.level.method_8320(class_2338.method_49637((double)this.position.x, (double)(this.position.y - 0.5), (double)this.position.z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getAge() {
        return this.age;
    }

    public int getLifetime() {
        return this.settings.particleLifetime();
    }

    public class_238 getBoundingBox() {
        return this.boundingBox;
    }

    public int getLightColor() {
        class_2338 pos = this.getBlockPosition();
        return this.level.method_22340(pos) ? class_761.method_23794((class_1920)this.level, (class_2338)pos) : 0;
    }

    public RenderData getRenderData() {
        return this.renderData;
    }

    public MolangEnvironment getEnvironment() {
        return this.environment;
    }

    public void vectorToRotation(double x, double y, double z) {
        this.rotation.set((float)Math.asin(y), (float)Math.atan2(x, z), 0.0f);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.updateBoundingBox();
    }

    public void setAge(int age) {
        this.age = age;
    }
}

