/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar;

import com.mojang.logging.LogUtils;
import foundry.veil.quasar.TickTaskScheduler;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class TickTaskSchedulerImpl
implements TickTaskScheduler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<Task> pendingTasks = new PriorityBlockingQueue<Task>();
    private long tick = 0L;
    private volatile boolean stopped = false;

    public void run() {
        Iterator iterator = this.pendingTasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.isDone()) {
                iterator.remove();
                continue;
            }
            if (this.tick < task.executionTick) break;
            try {
                task.runnable.run();
                task.finish(null);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to execute task", t);
                task.finish(t);
            }
            iterator.remove();
        }
        ++this.tick;
    }

    public void shutdown() {
        this.stopped = true;
        Iterator iterator = this.pendingTasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.isDone()) {
                iterator.remove();
                continue;
            }
            try {
                task.runnable.run();
                task.finish(null);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to execute task", t);
                task.finish(t);
            }
            iterator.remove();
            ++this.tick;
        }
        if (!this.pendingTasks.isEmpty()) {
            throw new IllegalStateException(this.pendingTasks.size() + " tasks were left over!");
        }
    }

    private void validate(Object command) {
        Objects.requireNonNull(command);
        if (this.stopped) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.validate(command);
        this.pendingTasks.add(new Task(command, 0L));
    }

    @Override
    public CompletableFuture<?> schedule(Runnable command, int delay) {
        this.validate(command);
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        CompletableFuture future = new CompletableFuture();
        Task task = new Task(() -> {
            try {
                command.run();
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, this.tick + (long)delay);
        this.pendingTasks.add(task);
        future.exceptionally(e -> {
            if (future.isCancelled()) {
                task.cancel(false);
            }
            return null;
        });
        return future;
    }

    @Override
    public <V> CompletableFuture<V> schedule(Callable<V> callable, int delay) {
        this.validate(callable);
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        CompletableFuture future = new CompletableFuture();
        Task task = new Task(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, this.tick + (long)delay);
        this.pendingTasks.add(task);
        future.exceptionally(e -> {
            if (future.isCancelled()) {
                task.cancel(false);
            }
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<?> scheduleAtFixedRate(Runnable command, int initialDelay, int period) {
        this.validate(command);
        if (initialDelay < 0 || period < 0) {
            throw new IllegalArgumentException();
        }
        CompletableFuture future = new CompletableFuture();
        Task task = this.schedule(future, command, new AtomicBoolean(), initialDelay, period);
        this.pendingTasks.add(task);
        future.exceptionally(e -> {
            if (future.isCancelled()) {
                task.cancel(false);
            }
            return null;
        });
        return future;
    }

    private Task schedule(CompletableFuture<?> future, Runnable command, AtomicBoolean cancelled, int delay, int period) {
        return new Task(() -> {
            try {
                command.run();
                if (!this.stopped) {
                    this.pendingTasks.add(this.schedule(future, command, cancelled, period, period));
                }
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, cancelled, this.tick + (long)delay);
    }

    @Override
    public boolean isShutdown() {
        return this.stopped;
    }

    private class Task
    implements ScheduledFuture<Object> {
        private final Runnable runnable;
        private final AtomicBoolean cancelled;
        private final long executionTick;
        private boolean complete;
        private Throwable error;

        private Task(Runnable task, long executionTick) {
            this(task, new AtomicBoolean(), executionTick);
        }

        private Task(Runnable task, AtomicBoolean cancelled, long executionTick) {
            this.runnable = task;
            this.cancelled = cancelled;
            this.executionTick = executionTick;
        }

        public void finish(@Nullable Throwable error) {
            this.complete = true;
            this.error = error;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return TimeUnit.MILLISECONDS.convert((this.executionTick - TickTaskSchedulerImpl.this.tick) * 50L, unit);
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            return Long.compareUnsigned(this.executionTick, ((Task)o).executionTick);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.cancelled.compareAndSet(false, true);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.complete || this.cancelled.get();
        }

        @Override
        public Object get() throws ExecutionException {
            if (this.error != null) {
                throw new ExecutionException(this.error);
            }
            return null;
        }

        @Override
        public Object get(long timeout, @NotNull TimeUnit unit) throws ExecutionException {
            return this.get();
        }
    }
}

