/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar;

import foundry.veil.api.client.render.VeilRenderType;
import foundry.veil.quasar.ParticleSystemManager;
import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.client.particle.QuasarVanillaParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.data.EmitterSettings;
import foundry.veil.quasar.data.ParticleEmitterData;
import foundry.veil.quasar.data.QuasarParticleData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleEmitter {
    private final ParticleSystemManager particleManager;
    private final class_638 level;
    private final ParticleEmitterData emitterData;
    private final class_5819 randomSource;
    private final Vector3d position;
    private final List<QuasarParticle> particles;
    private boolean removed;
    private int age;

    ParticleEmitter(ParticleSystemManager particleManager, class_638 level, ParticleEmitterData data) {
        this.particleManager = particleManager;
        this.level = level;
        this.emitterData = data;
        this.randomSource = class_5819.method_43047();
        this.position = new Vector3d();
        this.particles = new ArrayList<QuasarParticle>(data.maxParticles());
    }

    public void remove() {
        this.removed = true;
    }

    public void reset() {
        this.age = 0;
        this.removed = false;
    }

    @Nullable
    public class_2960 getRegistryName() {
        return this.emitterData.getRegistryId();
    }

    public boolean isRemoved() {
        return this.removed && this.particles.isEmpty();
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public ParticleEmitterData getData() {
        return this.emitterData;
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    @Deprecated
    public void setPosition(class_243 position) {
        this.position.set(position.field_1352, position.field_1351, position.field_1350);
    }

    public void setPosition(Vector3dc position) {
        this.position.set(position);
    }

    private void run() {
        EmitterSettings emitterSettings = this.emitterData.emitterSettings();
        Vector3d particlePos = emitterSettings.emitterShapeSettings().getPos(this.randomSource, (Vector3dc)this.position);
        Vector3f particleDirection = emitterSettings.particleSettings().particleDirection(this.randomSource);
        QuasarParticle particle = new QuasarParticle(this.level, this.randomSource, this.emitterData.particleData(), this.emitterData.emitterSettings().particleSettings(), this);
        particle.getPosition().set((Vector3dc)particlePos);
        particle.getVelocity().set((Vector3fc)particleDirection);
        particle.init();
        this.particles.add(particle);
    }

    public void tick() {
        Iterator<QuasarParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            QuasarParticle particle = iterator.next();
            particle.tick();
            if (!particle.isRemoved()) continue;
            iterator.remove();
            particle.onRemove();
        }
        if (!this.removed) {
            if (this.age % this.emitterData.rate() == 0) {
                int count = Math.min(this.emitterData.maxParticles(), (int)Math.ceil((float)this.emitterData.count() * this.particleManager.getSpawnScale()));
                for (int i = 0; i < count; ++i) {
                    this.run();
                }
            }
            if (this.age > this.emitterData.maxLifetime()) {
                if (this.emitterData.loop()) {
                    this.age = 0;
                } else {
                    this.remove();
                }
            }
        }
        ++this.age;
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTicks) {
        class_243 projectedView = camera.method_19326();
        QuasarParticleData particleData = this.emitterData.particleData();
        QuasarVanillaParticle.RenderStyle renderStyle = particleData.renderStyle();
        Vector3f renderOffset = new Vector3f();
        Vector3d motionDirection = new Vector3d();
        for (QuasarParticle particle : this.particles) {
            RenderData renderData = particle.getRenderData();
            particle.render(partialTicks);
            renderData.renderTrails(poseStack, bufferSource, projectedView, 0xF000F0);
            Vector3dc renderPosition = renderData.getRenderPosition();
            renderOffset.set((float)(renderPosition.x() - projectedView.method_10216()), (float)(renderPosition.y() - projectedView.method_10214()), (float)(renderPosition.z() - projectedView.method_10215()));
            particle.getVelocity().normalize(motionDirection);
            class_4588 builder = bufferSource.getBuffer(VeilRenderType.quasarParticle(renderData.getTexture()));
            renderStyle.render(poseStack, particle, renderData, (Vector3fc)renderOffset, (Vector3dc)motionDirection, particle.getLightColor(), builder, 1.0, partialTicks);
        }
    }

    @ApiStatus.Internal
    public void onRemoved() {
        for (QuasarParticle particle : this.particles) {
            particle.onRemove();
        }
        this.particles.clear();
    }
}

