/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderBindingProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPredefinitionProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderVersionProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import net.minecraft.class_7654;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class DirectShaderCompiler
implements ShaderCompiler {
    private static final boolean VERBOSE_ERRORS = System.getProperty("veil.verboseShaderErrors") != null;
    private final class_5912 provider;
    private final List<ShaderPreProcessor> preProcessors;
    private final List<ShaderPreProcessor> importProcessors;
    private final Set<Integer> shaders;
    private class_2960 compilingName;

    public DirectShaderCompiler(@Nullable class_5912 provider) {
        this.provider = provider;
        this.preProcessors = new LinkedList<ShaderPreProcessor>();
        this.importProcessors = new LinkedList<ShaderPreProcessor>();
        this.shaders = new HashSet<Integer>();
    }

    private String modifySource(ShaderCompiler.Context context, List<ShaderPreProcessor> preProcessors, Map<String, Integer> uniformBindings, Set<String> dependencies, @Nullable class_2960 name, String source, int type, boolean sourceFile) throws IOException {
        for (ShaderPreProcessor preProcessor : preProcessors) {
            source = preProcessor.modify(new PreProcessorContext(this, context, uniformBindings, dependencies, name, source, type, sourceFile));
        }
        return source;
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, class_2960 id) throws IOException, ShaderException {
        if (this.provider == null) {
            throw new IOException("Failed to read " + ShaderManager.getTypeName(type) + " from " + id + " because no provider was specified");
        }
        class_2960 location = context.sourceSet().getTypeConverter(type).method_45112(id);
        try {
            CompiledShader compiledShader;
            block10: {
                BufferedReader reader = this.provider.openAsReader(location);
                try {
                    this.compilingName = id;
                    compiledShader = this.compile(context, type, IOUtils.toString((Reader)reader));
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
            }
            return compiledShader;
        }
        finally {
            this.compilingName = null;
        }
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, String source) throws IOException, ShaderException {
        this.preProcessors.forEach(ShaderPreProcessor::prepare);
        HashMap<String, Integer> uniformBindings = new HashMap<String, Integer>();
        HashSet<String> dependencies = new HashSet<String>();
        source = this.modifySource(context, this.preProcessors, uniformBindings, dependencies, this.compilingName, source, type, true);
        int shader = GL20C.glCreateShader((int)type);
        GL20C.glShaderSource((int)shader, (CharSequence)source);
        GL20C.glCompileShader((int)shader);
        if (GL20C.glGetShaderi((int)shader, (int)35713) != 1) {
            Object log = GL20C.glGetShaderInfoLog((int)shader);
            if (VERBOSE_ERRORS) {
                log = (String)log + "\n" + source;
            }
            GL20C.glDeleteShader((int)shader);
            throw new ShaderException("Failed to compile " + ShaderManager.getTypeName(type) + " shader", (String)log);
        }
        this.shaders.add(shader);
        return new CompiledShader(shader, uniformBindings, dependencies);
    }

    @Override
    public void addPreprocessor(ShaderPreProcessor processor, boolean modifyImports) {
        this.preProcessors.add(processor);
        if (modifyImports) {
            this.importProcessors.add(processor);
        }
    }

    @Override
    public ShaderCompiler addDefaultProcessors() {
        if (this.provider != null) {
            this.addPreprocessor(new ShaderImportProcessor(this.provider));
        }
        this.addPreprocessor(new ShaderBindingProcessor());
        this.addPreprocessor(new ShaderPredefinitionProcessor(), false);
        this.addPreprocessor(new ShaderVersionProcessor(), false);
        return this;
    }

    public void free() {
        this.preProcessors.clear();
        this.shaders.forEach(GL20C::glDeleteShader);
        this.shaders.clear();
    }

    private record PreProcessorContext(DirectShaderCompiler compiler, ShaderCompiler.Context context, Map<String, Integer> uniformBindings, Set<String> dependencies, @Nullable class_2960 name, String input, int type, boolean sourceFile) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable class_2960 name, String source) throws IOException {
            return this.compiler.modifySource(this.context, this.compiler.importProcessors, this.uniformBindings, this.dependencies, name, source, this.type, false);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put(name, binding);
        }

        @Override
        public void addDefinitionDependency(String name) {
            this.dependencies.add(name);
        }

        @Override
        @Nullable
        public class_2960 getName() {
            return this.name;
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public class_7654 getConverter() {
            return this.context.sourceSet().getTypeConverter(this.getType());
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }

        @Override
        @Nullable
        public ProgramDefinition getDefinition() {
            return this.context.definition();
        }

        @Override
        public ShaderPreDefinitions getPreDefinitions() {
            return this.context.preDefinitions();
        }
    }
}

