/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client;

import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.render.mesh.ModelMesh;
import foundry.veil.api.client.graveyard.render.mesh.StaticMesh;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedBone;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;

@ApiStatus.Internal
public class DebugSkeletonFactory
implements SkeletonFactory<InterpolatedSkeleton> {
    private final ModelMesh[] meshes = new ModelMesh[3];

    public DebugSkeletonFactory() {
        int texWidth = 64;
        int texHeight = 128;
        StaticMesh mesh0 = new StaticMesh(texWidth, texHeight);
        mesh0.addCube(16.0f, 16.0f, 16.0f, -8.0f, 0.0f, -8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
        this.meshes[0] = mesh0;
        StaticMesh mesh1 = new StaticMesh(texWidth, texHeight);
        mesh1.addCube(8.0f, 16.0f, 13.0f, -4.0f, 0.0f, -6.5f, 0.0f, 0.0f, 0.0f, 0.0f, 32.0f, false);
        this.meshes[1] = mesh1;
        StaticMesh mesh2 = new StaticMesh(texWidth, texHeight);
        mesh2.addCube(7.0f, 7.0f, 12.0f, -3.5f, 0.0f, -6.0f, 0.0f, 0.0f, 0.0f, 0.0f, 61.0f, false);
        this.meshes[2] = mesh2;
    }

    @Override
    public InterpolatedSkeleton create() {
        DebugModel model = new DebugModel();
        InterpolatedBone boneBone = new InterpolatedBone("bone");
        boneBone.setInitialTransform(0.0f, 0.0f, 0.0f, new Quaternionf().rotationZYX(0.0f, 0.0f, 0.0f));
        model.addBone(boneBone, this.meshes[0]);
        model.bone = boneBone;
        InterpolatedBone bone2Bone = new InterpolatedBone("bone2");
        bone2Bone.setInitialTransform(2.0f, 16.0f, 0.0f, new Quaternionf().rotationZYX(-0.30543262f, 1.0035644f, -1.0331508E-16f));
        model.addBone(bone2Bone, this.meshes[1]);
        model.bone2 = bone2Bone;
        InterpolatedBone bone3Bone = new InterpolatedBone("bone3");
        bone3Bone.setInitialTransform(-3.0f, 16.0f, 2.220446E-16f, new Quaternionf().rotationZYX(-0.45652524f, 0.51944697f, -0.23913136f));
        model.addBone(bone3Bone, this.meshes[2]);
        model.bone3 = bone3Bone;
        boneBone.addChild(bone2Bone);
        bone2Bone.addChild(bone3Bone);
        model.buildRoots();
        return model;
    }

    public static class DebugModel
    extends InterpolatedSkeleton {
        protected InterpolatedBone bone;
        protected InterpolatedBone bone2;
        protected InterpolatedBone bone3;

        @Override
        public void animate(AnimationProperties properties) {
        }
    }
}

