/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import com.mojang.logging.LogUtils;
import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLEnvironmentOptions;
import foundry.veil.api.opencl.CLException;
import foundry.veil.lib.opencl.CL;
import foundry.veil.lib.opencl.CL10;
import foundry.veil.lib.opencl.CLCapabilities;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public final class VeilOpenCL
implements NativeResource {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<DeviceInfo> COMPUTE_ORDER = (p1, p2) -> {
        boolean gpu2;
        boolean gpu1 = p1.isGpu();
        return gpu1 == (gpu2 = p2.isGpu()) ? 0 : (gpu1 ? -1 : 1);
    };
    private static VeilOpenCL instance;
    private final Map<DeviceInfo, CLEnvironment> environments = new Object2ObjectArrayMap();
    private final Set<DeviceInfo> invalidDevices = new HashSet<DeviceInfo>();
    private final PlatformInfo[] platforms;
    private final List<DeviceInfo> priorityDevices;

    private VeilOpenCL() {
        PlatformInfo[] platforms;
        ArrayList<DeviceInfo> priorityDevices = new ArrayList<DeviceInfo>();
        try {
            for (PlatformInfo platform : platforms = VeilOpenCL.requestPlatforms()) {
                priorityDevices.addAll(Arrays.asList(platform.devices()));
            }
            priorityDevices.sort(COMPUTE_ORDER);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to load OpenCL");
            platforms = new PlatformInfo[]{};
            priorityDevices.clear();
        }
        this.platforms = platforms;
        this.priorityDevices = Collections.unmodifiableList(priorityDevices);
    }

    @Nullable
    public CLEnvironment getEnvironment() {
        return this.getEnvironment(CLEnvironmentOptions.DEFAULT);
    }

    @Nullable
    public CLEnvironment getEnvironment(CLEnvironmentOptions options) {
        for (DeviceInfo deviceInfo : this.getPriorityDevices()) {
            if (!options.testDevice(deviceInfo)) continue;
            return this.getEnvironment(deviceInfo);
        }
        return null;
    }

    @Nullable
    public CLEnvironment getEnvironment(DeviceInfo deviceInfo) {
        if (this.invalidDevices.contains(deviceInfo)) {
            return null;
        }
        CLEnvironment environment = this.environments.get(deviceInfo);
        if (environment == null) {
            try {
                environment = new CLEnvironment(deviceInfo);
                this.environments.put(deviceInfo, environment);
            }
            catch (CLException e) {
                this.invalidDevices.add(deviceInfo);
                LOGGER.error("Failed to create environment for device: " + deviceInfo.name(), (Throwable)e);
                return null;
            }
        }
        return environment;
    }

    public PlatformInfo[] getPlatforms() {
        return this.platforms;
    }

    public List<DeviceInfo> getPriorityDevices() {
        return this.priorityDevices;
    }

    @ApiStatus.Internal
    public void free() {
        VeilOpenCL.instance.environments.values().forEach(CLEnvironment::free);
        VeilOpenCL.instance.environments.clear();
    }

    @ApiStatus.Internal
    public static void tryFree() {
        if (instance != null) {
            instance.free();
            instance = null;
        }
    }

    public static VeilOpenCL get() {
        if (instance == null) {
            instance = new VeilOpenCL();
        }
        return instance;
    }

    public static void checkCLError(IntBuffer errcode) throws CLException {
        VeilOpenCL.checkCLError(errcode.get(0));
    }

    public static void checkCLError(int errcode) throws CLException {
        if (errcode != 0) {
            throw new CLException(errcode);
        }
    }

    public static String getProgramBuildInfo(long program, long device, int param) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer log_size = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10.clGetProgramBuildInfo(program, device, param, (PointerBuffer)null, log_size));
            ByteBuffer log_data = stack.malloc((int)log_size.get(0));
            VeilOpenCL.checkCLError(CL10.clGetProgramBuildInfo(program, device, param, log_data, null));
            String string = MemoryUtil.memASCII((ByteBuffer)log_data);
            return string;
        }
    }

    public static String getPlatformInfoString(long platform, int param) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10.clGetPlatformInfo(platform, param, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            VeilOpenCL.checkCLError(CL10.clGetPlatformInfo(platform, param, buffer, null));
            String string = MemoryUtil.memUTF8((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    public static String getDeviceInfoString(long device, int param) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10.clGetDeviceInfo(device, param, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            VeilOpenCL.checkCLError(CL10.clGetDeviceInfo(device, param, buffer, null));
            String string = MemoryUtil.memUTF8((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    public static int getDeviceInfoInt(long device, int param) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            VeilOpenCL.checkCLError(CL10.clGetDeviceInfo(device, param, pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    public static long getDeviceInfoLong(long device, int param) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pl = stack.mallocLong(1);
            VeilOpenCL.checkCLError(CL10.clGetDeviceInfo(device, param, pl, null));
            long l = pl.get(0);
            return l;
        }
    }

    private static PlatformInfo[] requestPlatforms() throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer num_platforms = stack.mallocInt(1);
            VeilOpenCL.checkCLError(CL10.clGetPlatformIDs(null, num_platforms));
            if (num_platforms.get(0) == 0) {
                PlatformInfo[] platformInfoArray = new PlatformInfo[]{};
                return platformInfoArray;
            }
            PointerBuffer platforms = stack.mallocPointer(num_platforms.get(0));
            VeilOpenCL.checkCLError(CL10.clGetPlatformIDs(platforms, (IntBuffer)null));
            PlatformInfo[] platformInfos = new PlatformInfo[platforms.capacity()];
            for (int i = 0; i < platformInfos.length; ++i) {
                platformInfos[i] = PlatformInfo.create(platforms.get(i), stack);
            }
            PlatformInfo[] platformInfoArray = platformInfos;
            return platformInfoArray;
        }
    }

    public record PlatformInfo(long id, CLCapabilities capabilities, String profile, String version, String name, String vendor, DeviceInfo[] devices) {
        public static PlatformInfo create(long platform, MemoryStack stack) throws CLException {
            CLCapabilities caps = CL.createPlatformCapabilities(platform);
            String profile = VeilOpenCL.getPlatformInfoString(platform, 2304);
            String version = VeilOpenCL.getPlatformInfoString(platform, 2305);
            String name = VeilOpenCL.getPlatformInfoString(platform, 2306);
            String vendor = VeilOpenCL.getPlatformInfoString(platform, caps.cl_khr_icd ? 2336 : 2307);
            IntBuffer num_devices = stack.mallocInt(1);
            VeilOpenCL.checkCLError(CL10.clGetDeviceIDs(platform, -1L, null, num_devices));
            DeviceInfo[] deviceInfos = new DeviceInfo[num_devices.get(0)];
            if (deviceInfos.length > 0) {
                PointerBuffer devices = stack.mallocPointer(deviceInfos.length);
                VeilOpenCL.checkCLError(CL10.clGetDeviceIDs(platform, -1L, devices, (IntBuffer)null));
                for (int i = 0; i < deviceInfos.length; ++i) {
                    deviceInfos[i] = DeviceInfo.create(devices.get(i), caps);
                }
            }
            return new PlatformInfo(platform, caps, profile, version, name, vendor, deviceInfos);
        }
    }

    public record DeviceInfo(long platform, long id, CLCapabilities capabilities, long type, int vendorId, int maxComputeUnits, int maxWorkItemDimensions, long maxWorkGroupSize, long maxMemAllocSize, int maxClockFrequency, int addressBits, boolean available, boolean compilerAvailable, String name, String vendor, String driverVersion, String profile, String version, @Nullable String openclCVersion) {
        public static DeviceInfo create(long device, CLCapabilities platformCapabilities) throws CLException {
            CLCapabilities caps = CL.createDeviceCapabilities(device, platformCapabilities);
            long platform = VeilOpenCL.getDeviceInfoLong(device, 4145);
            long deviceType = VeilOpenCL.getDeviceInfoLong(device, 4096);
            int vendorId = VeilOpenCL.getDeviceInfoInt(device, 4097);
            int maxComputeUnits = VeilOpenCL.getDeviceInfoInt(device, 4098);
            int maxWorkItemDimensions = VeilOpenCL.getDeviceInfoInt(device, 4099);
            long maxWorkGroupSize = VeilOpenCL.getDeviceInfoLong(device, 4100);
            long maxMemAllocSize = VeilOpenCL.getDeviceInfoLong(device, 4112);
            int maxClockFrequency = VeilOpenCL.getDeviceInfoInt(device, 4108);
            int addressBits = VeilOpenCL.getDeviceInfoInt(device, 4109);
            boolean available = VeilOpenCL.getDeviceInfoInt(device, 4135) == 1;
            boolean compilerAvailable = VeilOpenCL.getDeviceInfoInt(device, 4136) == 1;
            String name = VeilOpenCL.getDeviceInfoString(device, 4139);
            String vendor = VeilOpenCL.getDeviceInfoString(device, 4140);
            String driverVersion = VeilOpenCL.getDeviceInfoString(device, 4141);
            String profile = VeilOpenCL.getDeviceInfoString(device, 4142);
            String version = VeilOpenCL.getDeviceInfoString(device, 4143);
            String openclCVersion = caps.OpenCL11 ? VeilOpenCL.getDeviceInfoString(device, 4157) : null;
            return new DeviceInfo(platform, device, caps, deviceType, vendorId, maxComputeUnits, maxWorkItemDimensions, maxWorkGroupSize, maxMemAllocSize, maxClockFrequency, addressBits, available, compilerAvailable, name, vendor, driverVersion, profile, version, openclCVersion);
        }

        public boolean isCpu() {
            return (this.type & 2L) > 0L;
        }

        public boolean isGpu() {
            return (this.type & 4L) > 0L;
        }

        public boolean isAccelerator() {
            return (this.type & 8L) > 0L;
        }

        public boolean isDefault() {
            return (this.type & 1L) > 0L;
        }
    }
}

