/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLKernel;
import foundry.veil.api.opencl.CLMemObject;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.lib.opencl.CL10;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;

public class CLBuffer
implements CLMemObject {
    private final CLKernel kernel;
    private final CLEnvironment environment;
    private final long pointer;

    CLBuffer(CLKernel kernel, long pointer) {
        this.kernel = kernel;
        this.environment = kernel.getEnvironment();
        this.pointer = pointer;
    }

    public void write(long offset, ByteBuffer data) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, data, null, null));
    }

    public void write(long offset, ShortBuffer data) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, data, null, null));
    }

    public void write(long offset, IntBuffer data) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, data, null, null));
    }

    public void write(long offset, FloatBuffer data) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, data, null, null));
    }

    public void write(long offset, DoubleBuffer data) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, data, null, null));
    }

    public void read(long offset, ByteBuffer store) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, store, null, null));
    }

    public void read(long offset, ShortBuffer store) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, store, null, null));
    }

    public void read(long offset, IntBuffer store) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, store, null, null));
    }

    public void read(long offset, FloatBuffer store) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, store, null, null));
    }

    public void read(long offset, DoubleBuffer store) throws CLException {
        VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, true, offset, store, null, null));
    }

    public void writeAsync(long offset, ByteBuffer data, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, data, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void writeAsync(long offset, ShortBuffer data, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, data, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void writeAsync(long offset, IntBuffer data, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, data, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void writeAsync(long offset, FloatBuffer data, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, data, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void writeAsync(long offset, DoubleBuffer data, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueWriteBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, data, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void readAsync(long offset, ByteBuffer store, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, store, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void readAsync(long offset, ShortBuffer store, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, store, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void readAsync(long offset, IntBuffer store, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, store, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void readAsync(long offset, FloatBuffer store, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, store, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    public void readAsync(long offset, DoubleBuffer store, @Nullable Runnable onComplete) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer event = onComplete != null ? stack.mallocPointer(1) : null;
            VeilOpenCL.checkCLError(CL10.clEnqueueReadBuffer(this.environment.getCommandQueue(), this.pointer, false, offset, store, null, event));
            if (event != null) {
                this.environment.getEventDispatcher().listen(event.get(0), onComplete);
            }
        }
    }

    @Override
    public long pointer() {
        return this.pointer;
    }

    public void free() {
        this.kernel.free(this);
    }
}

