/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.definition;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ShaderPreDefinitions {
    private final Set<Consumer<String>> definitionCallbacks = new HashSet<Consumer<String>>();
    private final Map<String, String> definitions = new HashMap<String, String>();
    private final Map<String, String> definitionsView = Collections.unmodifiableMap(this.definitions);
    private final Map<String, String> staticDefinitions = new HashMap<String, String>();

    private String getDefinition(String name, @Nullable String definition) {
        name = name.toUpperCase(Locale.ROOT);
        if (definition == null) {
            return "#define " + name;
        }
        return "#define " + name + " " + definition;
    }

    public void addListener(Consumer<String> definitionCallback) {
        this.definitionCallbacks.add(definitionCallback);
    }

    public void define(String name) {
        this.define(name, null);
    }

    public void define(String name, @Nullable String definition) {
        this.set(name, this.getDefinition(name, definition));
    }

    public void set(String name, String definition) {
        String previous = this.definitions.put(name, definition);
        if (!Objects.equals(previous, definition)) {
            this.definitionCallbacks.forEach(callback -> callback.accept(name));
        }
    }

    public void defineStatic(String name) {
        this.defineStatic(name, null);
    }

    public void defineStatic(String name, @Nullable String definition) {
        this.setStatic(name, this.getDefinition(name, definition));
    }

    public void setStatic(String name, String definition) {
        this.staticDefinitions.put(name, definition);
    }

    public void remove(String name) {
        if (this.definitions.remove(name) != null) {
            this.definitionCallbacks.forEach(callback -> callback.accept(name));
        }
    }

    public void addStaticDefinitions(Consumer<String> definitionConsumer) {
        this.staticDefinitions.values().forEach(definitionConsumer);
    }

    @Nullable
    public String getDefinition(String name) {
        return this.definitions.get(name);
    }

    public Map<String, String> getDefinitions() {
        return this.definitions;
    }
}

