/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import java.nio.ByteBuffer;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PointLight
extends Light
implements InstancedLight,
PositionedLight<PointLight> {
    protected final Vector3d position = new Vector3d();
    protected float radius = 1.0f;
    protected float falloff = 0.0f;

    @Override
    public void store(ByteBuffer buffer) {
        this.position.getf(buffer.position(), buffer);
        buffer.position(buffer.position() + 12);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        buffer.putFloat(this.radius);
        buffer.putFloat(this.falloff);
    }

    @Override
    public boolean isVisible(CullFrustum frustum) {
        double minX = this.position.x() - (double)this.radius;
        double minY = this.position.y() - (double)this.radius;
        double minZ = this.position.z() - (double)this.radius;
        double maxX = this.position.x() + (double)this.radius;
        double maxY = this.position.y() + (double)this.radius;
        double maxZ = this.position.z() + (double)this.radius;
        return frustum.testAab(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getFalloff() {
        return this.falloff;
    }

    @Override
    public PointLight setColor(float red, float green, float blue) {
        return (PointLight)super.setColor(red, green, blue);
    }

    @Override
    public PointLight setColor(Vector3fc color) {
        return (PointLight)super.setColor(color);
    }

    @Override
    public PointLight setBrightness(float brightness) {
        return (PointLight)super.setBrightness(brightness);
    }

    @Override
    public PointLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.markDirty();
        return this;
    }

    public PointLight setRadius(float radius) {
        this.radius = radius;
        this.markDirty();
        return this;
    }

    public PointLight setFalloff(float falloff) {
        this.falloff = falloff;
        this.markDirty();
        return this;
    }

    @Override
    public Light.Type getType() {
        return Light.Type.POINT;
    }

    @Override
    public PointLight clone() {
        return ((PointLight)new PointLight().setPosition((Vector3dc)this.position)).setColor((Vector3fc)this.color).setRadius(this.radius).setBrightness(this.brightness);
    }
}

