/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.impl.client.VeilImGuiImpl;
import foundry.veil.impl.client.render.pipeline.VeilUniformBlockState;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_286;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.slf4j.Logger;

public final class VeilRenderSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Executor RENDER_THREAD_EXECUTOR = task -> {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(task::run);
        } else {
            task.run();
        }
    };
    private static final Set<class_2960> ERRORED_SHADERS = new HashSet<class_2960>();
    private static final VeilUniformBlockState UNIFORM_BLOCK_STATE = new VeilUniformBlockState();
    private static final IntSupplier MAX_COLOR_ATTACHMENTS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)36063));
    private static final IntSupplier MAX_UNIFORM_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35375));
    private static final Supplier<Vector2ic> MAX_FRAMEBUFFER_SIZE = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        boolean gl43 = GL.getCapabilities().OpenGL43;
        int width = gl43 ? GL11C.glGetInteger((int)37653) : Integer.MAX_VALUE;
        int height = gl43 ? GL11C.glGetInteger((int)37654) : Integer.MAX_VALUE;
        return new Vector2i(width, height);
    });
    private static VeilRenderer renderer;
    private static class_2960 shaderLocation;

    private VeilRenderSystem() {
    }

    private static IntSupplier glGetter(final IntSupplier delegate) {
        return new IntSupplier(){
            private int value = Integer.MAX_VALUE;

            @Override
            public int getAsInt() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == Integer.MAX_VALUE) {
                    this.value = delegate.getAsInt();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    @ApiStatus.Internal
    public static void init() {
        class_310 client = class_310.method_1551();
        class_3300 class_33002 = client.method_1478();
        if (!(class_33002 instanceof class_3304)) {
            throw new IllegalStateException("Client resource manager is " + client.method_1478().getClass());
        }
        class_3304 resourceManager = (class_3304)class_33002;
        renderer = new VeilRenderer(resourceManager);
        VeilImGuiImpl.init(client.method_22683().method_4490());
    }

    public static void setShader(class_2960 shader) {
        ShaderManager shaderManager = renderer.getShaderManager();
        VeilRenderSystem.setShader(() -> shaderManager.getShader(shader));
        shaderLocation = shader;
    }

    public static void setShader(@Nullable ShaderProgram shader) {
        VeilRenderSystem.setShader(() -> shader);
        shaderLocation = shader != null ? shader.getId() : null;
    }

    public static void setShader(Supplier<ShaderProgram> shader) {
        RenderSystem.setShader(() -> {
            ShaderProgram program = (ShaderProgram)shader.get();
            return program != null ? program.toShaderInstance() : null;
        });
    }

    public static void finalizeShaderCompilation() {
        ERRORED_SHADERS.clear();
        UNIFORM_BLOCK_STATE.queueUpload();
    }

    public static void throwShaderError() {
        if (shaderLocation != null && ERRORED_SHADERS.add(shaderLocation)) {
            LOGGER.error("Failed to apply shader: " + shaderLocation);
        }
    }

    public static int maxColorAttachments() {
        return MAX_COLOR_ATTACHMENTS.getAsInt();
    }

    public static int maxUniformBuffersBindings() {
        return MAX_UNIFORM_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxFramebufferWidth() {
        return MAX_FRAMEBUFFER_SIZE.get().x();
    }

    public static int maxFramebufferHeight() {
        return MAX_FRAMEBUFFER_SIZE.get().y();
    }

    public static void bind(ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.bind(block);
    }

    public static void bind(CharSequence name, ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.bind(name, block);
    }

    public static void unbind(ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.unbind(block);
    }

    public static void bindVertexArray(int vao) {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)vao);
    }

    public static VeilRenderer renderer() {
        return renderer;
    }

    public static Executor renderThreadExecutor() {
        return RENDER_THREAD_EXECUTOR;
    }

    @Nullable
    public static ShaderProgram getShader() {
        ShaderProgram shaderProgram;
        class_5944 shader = RenderSystem.getShader();
        if (shader instanceof ShaderProgramImpl.Wrapper) {
            ShaderProgramImpl.Wrapper wrapper = (ShaderProgramImpl.Wrapper)shader;
            shaderProgram = wrapper.program();
        } else {
            shaderProgram = null;
        }
        return shaderProgram;
    }

    @ApiStatus.Internal
    public static void beginFrame() {
        VeilImGuiImpl.get().begin();
    }

    @ApiStatus.Internal
    public static void endFrame() {
        VeilImGuiImpl.get().end();
        renderer.getFramebufferManager().clear();
    }

    @ApiStatus.Internal
    public static void shaderUpdate() {
        shaderLocation = null;
    }

    @ApiStatus.Internal
    public static void resize(int width, int height) {
        if (renderer != null) {
            renderer.getFramebufferManager().resizeFramebuffers(width, height);
        }
    }

    @ApiStatus.Internal
    public static void close() {
        VeilImGuiImpl.get().free();
        VeilOpenCL.tryFree();
        if (renderer != null) {
            renderer.free();
        }
    }

    @ApiStatus.Internal
    public static void renderPost(float partialTicks) {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        FramebufferManager framebufferManager = renderer.getFramebufferManager();
        PostProcessingManager postProcessingManager = renderer.getPostProcessingManager();
        if (postProcessingManager.getActivePipelines().isEmpty()) {
            return;
        }
        AdvancedFbo postFramebuffer = framebufferManager.getFramebuffer(VeilFramebuffers.POST);
        if (postFramebuffer != null) {
            AdvancedFbo.getMainFramebuffer().resolveToAdvancedFbo(postFramebuffer);
        }
        postProcessingManager.runPipeline();
        if (postFramebuffer != null) {
            postFramebuffer.resolveToFramebuffer(class_310.method_1551().method_1522());
        }
    }
}

