/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import foundry.veil.lib.asm.Label;
import foundry.veil.lib.asm.tree.MethodNode;
import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ScopeNode(Node node) implements Node
{
    @Override
    public String toString() {
        return "{" + this.node + "}";
    }

    @Override
    public boolean isConstant() {
        return this.node.isConstant();
    }

    @Override
    public boolean hasValue() {
        return this.node.hasValue();
    }

    @Override
    public float evaluate(MolangBytecodeEnvironment environment) throws MolangException {
        return this.node.evaluate(environment);
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        MolangBytecodeEnvironment scopeEnvironment = new MolangBytecodeEnvironment(environment);
        this.node.writeBytecode(method, scopeEnvironment, breakLabel, continueLabel);
        scopeEnvironment.writeModifiedVariables(method);
    }
}

