/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters;

import foundry.veil.quasar.data.ParticleEmitterData;
import foundry.veil.quasar.data.QuasarParticles;
import foundry.veil.quasar.emitters.ParticleEmitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class ParticleSystemManager {
    private static ParticleSystemManager instance;
    private final List<ParticleEmitter> particleEmitters = new ArrayList<ParticleEmitter>();
    private final Queue<ParticleEmitter> particleSystemsToAdd = new ConcurrentLinkedQueue<ParticleEmitter>();
    public static int PARTICLE_COUNT;

    public static ParticleSystemManager getInstance() {
        if (instance == null) {
            instance = new ParticleSystemManager();
        }
        return instance;
    }

    @Nullable
    public ParticleEmitter createEmitter(class_1937 level, class_2960 name) {
        if (!(level instanceof class_638)) {
            return null;
        }
        class_638 clientLevel = (class_638)level;
        ParticleEmitterData data = (ParticleEmitterData)QuasarParticles.registryAccess().method_30530(QuasarParticles.EMITTER).method_10223(name);
        return data != null ? new ParticleEmitter(clientLevel, data) : null;
    }

    public void addParticleSystem(ParticleEmitter particleEmitter) {
        this.particleSystemsToAdd.add(particleEmitter);
    }

    public void clear() {
        this.particleEmitters.clear();
    }

    public void tick() {
        this.particleEmitters.addAll(this.particleSystemsToAdd);
        this.particleSystemsToAdd.clear();
        Iterator<ParticleEmitter> iterator = this.particleEmitters.iterator();
        while (iterator.hasNext()) {
            ParticleEmitter emitter = iterator.next();
            emitter.tick();
            if (!emitter.isRemoved()) continue;
            iterator.remove();
        }
        PARTICLE_COUNT = this.particleEmitters.stream().mapToInt(ParticleEmitter::getParticleCount).sum();
    }

    public float getSpawnScale() {
        return 1.0f - (float)(PARTICLE_COUNT - 1000) / 3000.0f * 0.66f;
    }

    static {
        PARTICLE_COUNT = 0;
    }
}

