/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters;

import foundry.veil.quasar.client.particle.QuasarVanillaParticle;
import foundry.veil.quasar.data.EmitterSettings;
import foundry.veil.quasar.data.ParticleEmitterData;
import foundry.veil.quasar.emitters.ParticleSystemManager;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class ParticleEmitter {
    private final class_638 level;
    private final Vector3d position;
    private final ParticleEmitterData emitterData;
    private boolean removed;
    private int particleCount = 0;
    private int age;

    public ParticleEmitter(class_638 level, ParticleEmitterData data) {
        this.level = level;
        this.emitterData = data;
        this.position = new Vector3d();
    }

    public void remove() {
        this.removed = true;
    }

    public void reset() {
        this.age = 0;
        this.removed = false;
    }

    @Nullable
    public class_2960 getRegistryName() {
        return this.emitterData.getRegistryId();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public ParticleEmitterData getData() {
        return this.emitterData;
    }

    public int getAge() {
        return this.age;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    @Deprecated
    public void setPosition(class_243 position) {
        this.position.set(position.field_1352, position.field_1351, position.field_1350);
    }

    public void setPosition(Vector3dc position) {
        this.position.set(position);
    }

    private void run() {
        class_5819 random = this.level.field_9229;
        EmitterSettings emitterSettings = this.emitterData.emitterSettings();
        Vector3d particlePos = emitterSettings.emitterShapeSettings().getPos(random, (Vector3dc)this.position);
        Vector3f particleDirection = emitterSettings.particleSettings().particleDirection(random);
        class_310.method_1551().field_1713.method_3058((class_703)new QuasarVanillaParticle(this.emitterData.particleData(), this.emitterData.emitterSettings().particleSettings(), this, this.level, particlePos.x(), particlePos.y(), particlePos.z(), particleDirection.x(), particleDirection.y(), particleDirection.z()));
    }

    public void tick() {
        if (this.age % this.emitterData.rate() == 0) {
            int count = (int)((float)this.emitterData.count() * ParticleSystemManager.getInstance().getSpawnScale());
            for (int i = 0; i < count; ++i) {
                this.run();
            }
        }
        ++this.age;
        if (this.age >= this.emitterData.maxLifetime()) {
            if (this.emitterData.loop()) {
                this.age = 0;
            } else {
                this.remove();
            }
        }
    }

    @ApiStatus.Internal
    public void particleAdded() {
        ++this.particleCount;
    }

    @ApiStatus.Internal
    public void particleRemoved() {
        --this.particleCount;
    }
}

