/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.quasar.data.QuasarParticles;
import foundry.veil.quasar.util.CodecUtil;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ParticleSettings(float particleSpeed, float particleSize, float particleSizeVariation, int particleLifetime, float particleLifetimeVariation, Vector3fc initialDirection, boolean randomInitialDirection, boolean randomInitialRotation, boolean randomSpeed, boolean randomSize, boolean randomLifetime) {
    public static final Codec<ParticleSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("particle_speed").forGetter(ParticleSettings::particleSpeed), (App)Codec.FLOAT.fieldOf("base_particle_size").forGetter(ParticleSettings::particleSize), (App)Codec.FLOAT.fieldOf("particle_size_variation").forGetter(ParticleSettings::particleSizeVariation), (App)Codec.INT.fieldOf("particle_lifetime").forGetter(ParticleSettings::particleLifetime), (App)Codec.FLOAT.fieldOf("particle_lifetime_variation").forGetter(ParticleSettings::particleLifetimeVariation), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("initial_direction").forGetter(ParticleSettings::initialDirection), (App)Codec.BOOL.fieldOf("random_initial_direction").forGetter(ParticleSettings::randomInitialDirection), (App)Codec.BOOL.fieldOf("random_initial_rotation").forGetter(ParticleSettings::randomInitialRotation), (App)Codec.BOOL.fieldOf("random_speed").forGetter(ParticleSettings::randomSpeed), (App)Codec.BOOL.fieldOf("random_size").forGetter(ParticleSettings::randomSize), (App)Codec.BOOL.fieldOf("random_lifetime").forGetter(ParticleSettings::randomLifetime)).apply((Applicative)instance, ParticleSettings::new));
    public static final Codec<class_6880<ParticleSettings>> CODEC = class_5381.method_29749(QuasarParticles.PARTICLE_SETTINGS, DIRECT_CODEC);

    public float particleSpeed(class_5819 random) {
        return this.randomSpeed ? this.particleSpeed + (random.method_43057() * 0.5f - 0.5f) * this.particleSpeed : this.particleSpeed;
    }

    public float particleSize(class_5819 random) {
        return this.randomSize ? this.particleSize + random.method_43057() * this.particleSizeVariation : this.particleSize;
    }

    public int particleLifetime(class_5819 random) {
        return this.randomLifetime ? this.particleLifetime + (int)(random.method_43057() * this.particleLifetimeVariation) : this.particleLifetime;
    }

    public Vector3fc initialDirection(class_5819 random) {
        return this.randomInitialDirection ? this.initialDirection.mul(random.method_43057() * 2.0f - 1.0f, random.method_43057() * 2.0f - 1.0f, random.method_43057() * 2.0f - 1.0f, new Vector3f()) : this.initialDirection;
    }

    public Vector3f particleDirection(class_5819 random) {
        return this.initialDirection(random).mul(this.particleSpeed(), new Vector3f());
    }

    @Nullable
    public class_2960 getRegistryId() {
        return QuasarParticles.registryAccess().method_30530(QuasarParticles.PARTICLE_SETTINGS).method_10221((Object)this);
    }
}

