/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import foundry.veil.api.client.render.shader.RenderTypeRegistry;
import foundry.veil.quasar.client.particle.QuasarParticleRenderType;
import foundry.veil.quasar.client.particle.SpriteData;
import foundry.veil.quasar.emitters.modules.particle.render.TrailSettings;
import foundry.veil.quasar.fx.Trail;
import foundry.veil.quasar.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4fc;

public class RenderData {
    private final Vector3d prevPosition = new Vector3d();
    private final Vector3d renderPosition = new Vector3d();
    private final Vector3f prevRotation = new Vector3f();
    private final Vector3f renderRotation = new Vector3f();
    private float prevScale = 1.0f;
    private float renderScale = 1.0f;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;
    public float renderAge = 0.0f;
    public float agePercent;
    private SpriteData spriteData = null;
    private class_1058 atlasSprite = null;
    private final class_3999 renderType = new QuasarParticleRenderType();
    private final List<TrailSettings> trails = new ArrayList<TrailSettings>();
    private final List<Trail> renderTrails = new ArrayList<Trail>();

    @ApiStatus.Internal
    public void tick(Vector3dc position, Vector3fc rotation, float scale) {
        this.prevPosition.set(position);
        this.prevRotation.set(rotation);
        this.prevScale = scale;
    }

    @ApiStatus.Internal
    public void render(Vector3dc position, Vector3fc rotation, float scale, int age, int lifetime, float partialTicks) {
        this.prevPosition.lerp(position, (double)partialTicks, this.renderPosition);
        this.prevRotation.lerp(rotation, partialTicks, this.renderRotation);
        this.renderScale = class_3532.method_16439((float)partialTicks, (float)this.prevScale, (float)scale);
        this.renderAge = (float)age + partialTicks;
        this.agePercent = Math.min(this.renderAge / (float)lifetime, 1.0f);
    }

    public Vector3dc getRenderPosition() {
        return this.renderPosition;
    }

    public Vector3fc getRenderRotation() {
        return this.renderRotation;
    }

    public float getRenderScale() {
        return this.renderScale;
    }

    public float getRenderAge() {
        return this.renderAge;
    }

    public float getAgePercent() {
        return this.agePercent;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Nullable
    public SpriteData getSpriteData() {
        return this.spriteData;
    }

    public class_1058 getAtlasSprite() {
        return this.atlasSprite;
    }

    public class_3999 getRenderType() {
        return this.renderType;
    }

    public List<TrailSettings> getTrails() {
        return this.trails;
    }

    public void renderTrails(class_243 cameraPos, int packedLight) {
        this.trails.forEach(trail -> {
            Trail tr = new Trail(MathUtil.colorFromVec4f(trail.getTrailColor()), ageScale -> Float.valueOf(trail.getTrailWidthModifier().modify(ageScale.floatValue(), 1.0)));
            tr.setBillboard(trail.getBillboard());
            tr.setLength(trail.getTrailLength());
            tr.setFrequency(trail.getTrailFrequency());
            tr.setTilingMode(trail.getTilingMode());
            tr.setTexture(trail.getTrailTexture());
            tr.setParentRotation(trail.getParentRotation());
            tr.pushRotatedPoint(new class_243(this.prevPosition.x, this.prevPosition.y, this.prevPosition.z), new class_243((double)this.prevRotation.x, (double)this.prevRotation.y, (double)this.prevRotation.z));
            this.renderTrails.add(tr);
        });
        this.trails.clear();
        this.renderTrails.forEach(trail -> {
            trail.pushRotatedPoint(new class_243(this.renderPosition.x, this.renderPosition.y, this.renderPosition.z), new class_243((double)this.renderRotation.x, (double)this.renderRotation.y, (double)this.renderRotation.z));
            class_4587 ps = new class_4587();
            ps.method_22903();
            ps.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
            trail.render(ps, class_310.method_1551().method_22940().method_23000().getBuffer(RenderTypeRegistry.translucentNoCull(trail.getTexture())), packedLight);
            ps.method_22909();
        });
    }

    public List<Trail> getRenderTrails() {
        return this.renderTrails;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setColor(Vector4fc color) {
        this.red = color.x();
        this.green = color.y();
        this.blue = color.z();
        this.alpha = color.w();
    }

    public void addTrails(TrailSettings ... trails) {
        this.trails.addAll(List.of(trails));
    }

    public void addTrails(Collection<TrailSettings> trails) {
        this.trails.addAll(trails);
    }

    public void setSpriteData(@Nullable SpriteData spriteData) {
        this.spriteData = spriteData;
    }

    public void setAtlasSprite(@Nullable class_1058 atlasSprite) {
        this.atlasSprite = atlasSprite;
    }
}

