/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import com.mojang.logging.LogUtils;
import foundry.veil.quasar.client.particle.ParticleModuleSet;
import foundry.veil.quasar.client.particle.QuasarParticleLibrary;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.data.module.ParticleModuleData;
import foundry.veil.quasar.emitters.ParticleEmitter;
import foundry.veil.quasar.emitters.modules.particle.InitParticleModule;
import foundry.veil.quasar.emitters.modules.particle.ParticleModule;
import foundry.veil.quasar.emitters.modules.particle.RenderParticleModule;
import foundry.veil.quasar.emitters.modules.particle.UpdateParticleModule;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public class QuasarParticle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<class_6880<ParticleModuleData>> REPORTED_MODULES = new HashSet<class_6880<ParticleModuleData>>();
    private final class_638 level;
    private final class_5819 randomSource;
    private final QuasarParticleData data;
    private final ParticleSettings settings;
    private final ParticleEmitter parent;
    private final ParticleModuleSet modules;
    private final Vector3d position;
    private final Vector3d velocity;
    private final Vector3f rotation;
    private final class_2338.class_2339 blockPosition;
    private float scale;
    private final int lifetime;
    private int age;
    private final MolangRuntime environment;
    private final RenderData renderData;

    public QuasarParticle(class_638 level, QuasarParticleData data, ParticleSettings settings, @Nullable ParticleEmitter parent) {
        this.level = level;
        this.randomSource = class_5819.method_43047();
        this.data = data;
        this.settings = settings;
        this.parent = parent;
        this.modules = QuasarParticle.createModuleSet(data);
        this.position = new Vector3d();
        this.velocity = new Vector3d();
        this.rotation = new Vector3f();
        this.blockPosition = new class_2338.class_2339();
        this.scale = settings.particleSize(this.randomSource);
        this.lifetime = settings.particleLifetime(this.randomSource);
        this.age = 0;
        this.renderData = new RenderData();
        this.environment = (MolangRuntime)MolangRuntime.runtime().loadLibrary("quasar", new QuasarParticleLibrary(this)).setQuery("x", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().x()))).setQuery("y", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().y()))).setQuery("z", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().z()))).setQuery("velX", MolangExpression.of(() -> Float.valueOf((float)this.velocity.x()))).setQuery("velY", MolangExpression.of(() -> Float.valueOf((float)this.velocity.y()))).setQuery("velZ", MolangExpression.of(() -> Float.valueOf((float)this.velocity.z()))).setQuery("speedSq", MolangExpression.of(() -> Float.valueOf((float)this.velocity.lengthSquared()))).setQuery("speed", MolangExpression.of(() -> Float.valueOf((float)this.velocity.length()))).setQuery("xRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().x())))).setQuery("yRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().y())))).setQuery("zRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().z())))).setQuery("scale", MolangExpression.of(this.renderData::getRenderScale)).setQuery("age", MolangExpression.of(this.renderData::getRenderAge)).setQuery("agePercent", MolangExpression.of(this.renderData::getAgePercent)).setQuery("lifetime", this.lifetime).create();
        if (this.parent != null) {
            this.parent.particleAdded();
        }
    }

    @ApiStatus.Internal
    public void init() {
        for (InitParticleModule initModule : this.modules.getInitModules()) {
            initModule.init(this);
        }
        this.renderData.tick((Vector3dc)this.position, (Vector3fc)this.rotation, this.scale);
    }

    @ApiStatus.Internal
    public static void clearErrors() {
        REPORTED_MODULES.clear();
    }

    private static ParticleModuleSet createModuleSet(QuasarParticleData data) {
        ParticleModuleSet.Builder builder = ParticleModuleSet.builder();
        data.allModules().forEach(module -> {
            if (!module.method_40227()) {
                if (REPORTED_MODULES.add((class_6880<ParticleModuleData>)module)) {
                    String string;
                    if (module instanceof class_6880.class_6883) {
                        class_6880.class_6883 ref = (class_6880.class_6883)module;
                        string = ref.method_40237().method_29177();
                    } else {
                        string = module.getClass().getName();
                    }
                    LOGGER.error("Unknown module: {}", (Object)string);
                }
                return;
            }
            ((ParticleModuleData)module.comp_349()).addModules(builder);
        });
        return builder.build();
    }

    public void tick() {
        this.renderData.tick((Vector3dc)this.position, (Vector3fc)this.rotation, this.scale);
        for (UpdateParticleModule updateParticleModule : this.modules.getUpdateModules()) {
            updateParticleModule.update(this);
        }
        for (ParticleModule particleModule : this.modules.getForceModules()) {
            particleModule.applyForce(this);
        }
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
    }

    public void render(float partialTicks) {
        for (RenderParticleModule renderModule : this.modules.getRenderModules()) {
            renderModule.render(this, partialTicks);
        }
        this.renderData.render((Vector3dc)this.position, (Vector3fc)this.rotation, this.scale, this.age, this.lifetime, partialTicks);
    }

    public void onRemove() {
        this.parent.particleRemoved();
        for (ParticleModule module : this.modules.getAllModules()) {
            module.onRemove();
        }
    }

    public void remove() {
        this.age = Integer.MAX_VALUE;
    }

    public boolean isRemoved() {
        return this.age == Integer.MAX_VALUE;
    }

    public class_638 getLevel() {
        return this.level;
    }

    public class_5819 getRandomSource() {
        return this.randomSource;
    }

    public QuasarParticleData getData() {
        return this.data;
    }

    public ParticleSettings getSettings() {
        return this.settings;
    }

    public ParticleEmitter getParent() {
        return this.parent;
    }

    public ParticleModuleSet getModules() {
        return this.modules;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public class_2338 getBlockPosition() {
        return this.blockPosition.method_10102(this.position.x, this.position.y, this.position.z);
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public class_2680 getBlockStateInOrUnder() {
        class_2680 in = this.level.method_8320(class_2338.method_49637((double)this.position.x, (double)(this.position.y + 0.5), (double)this.position.z));
        if (!in.method_26215()) {
            return in;
        }
        return this.level.method_8320(class_2338.method_49637((double)this.position.x, (double)(this.position.y - 0.5), (double)this.position.z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public float getScale() {
        return this.scale;
    }

    public int getAge() {
        return this.age;
    }

    public int getLifetime() {
        return this.settings.particleLifetime();
    }

    public RenderData getRenderData() {
        return this.renderData;
    }

    public MolangEnvironment getEnvironment() {
        return this.environment;
    }

    public void vectorToRotation(double x, double y, double z) {
        this.rotation.set((float)Math.asin(y), (float)Math.atan2(x, z), 0.0f);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

