/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import imgui.ImGui;
import imgui.type.ImInt;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PostEditor
extends SingleWindowEditor {
    private final Set<class_2960> removedPipelines = new HashSet<class_2960>(1);

    @Override
    public void renderComponents() {
        this.removedPipelines.clear();
        PostProcessingManager postProcessing = VeilRenderSystem.renderer().getPostProcessingManager();
        float lineHeight = ImGui.getTextLineHeightWithSpacing();
        ImGui.text("Active Pipelines:");
        if (ImGui.beginListBox("##shaders", -1.4E-45f, 0.0f)) {
            for (PostProcessingManager.ProfileEntry profileEntry : postProcessing.getActivePipelines()) {
                class_2960 id = profileEntry.getPipeline();
                ImInt editPriority = new ImInt(profileEntry.getPriority());
                ImGui.pushID(id.toString());
                ImGui.text(id.toString());
                ImGui.sameLine(ImGui.getContentRegionAvailX() / 2.0f);
                ImGui.setNextItemWidth(-lineHeight - ImGui.getStyle().getCellPaddingX() * 2.0f);
                if (ImGui.dragScalar("##priority", 4, editPriority, 1.0f)) {
                    profileEntry.setPriority(editPriority.get());
                }
                ImGui.sameLine();
                if (ImGui.button("X", lineHeight, lineHeight)) {
                    this.removedPipelines.add(id);
                }
                ImGui.popID();
            }
            ImGui.endListBox();
        }
        ImGui.text("Add Pipeline:");
        if (ImGui.beginListBox("##available_pipelines", -1.4E-45f, 0.0f)) {
            for (class_2960 class_29602 : postProcessing.getPipelines()) {
                if (postProcessing.isActive(class_29602) || !ImGui.selectable(class_29602.toString(), false)) continue;
                postProcessing.add(class_29602);
            }
            ImGui.endListBox();
        }
        for (class_2960 class_29603 : this.removedPipelines) {
            postProcessing.remove(class_29603);
        }
    }

    @Override
    public String getDisplayName() {
        return "Post Shaders";
    }
}

