/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.DirectionalLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import imgui.ImGui;
import imgui.ImVec4;
import imgui.type.ImBoolean;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.util.ArrayList;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightEditor
extends SingleWindowEditor {
    private final Light.Type[] lightTypes = Light.Type.values();

    @Override
    public String getDisplayName() {
        return "Light Editor";
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }

    @Override
    protected void renderComponents() {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        float lineHeight = ImGui.getTextLineHeightWithSpacing();
        ArrayList lights = new ArrayList();
        for (Light.Type lightType : this.lightTypes) {
            lights.addAll(lightRenderer.getLights(lightType));
        }
        if (ImGui.beginTable("##lights", 2)) {
            ImGui.tableSetupColumn("     Lights");
            ImGui.tableSetupColumn("Visible", 16, lineHeight * 3.0f);
            ImGui.tableHeadersRow();
            ImGui.indent();
            for (int i = 0; i < lights.size(); ++i) {
                Light light = (Light)lights.get(i);
                boolean visible = light.isVisible(VeilRenderer.getCullingFrustum());
                if (!visible) {
                    ImVec4 textColor = ImGui.getStyle().getColor(0);
                    ImGui.pushStyleColor(0, textColor.x, textColor.y, textColor.z, textColor.w * 0.5f);
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex(0);
                LightEditor.renderLightComponents(light, i);
                ImGui.tableSetColumnIndex(1);
                ImBoolean isVisible = new ImBoolean(visible);
                ImGui.checkbox("##visible" + i, isVisible);
                if (visible) continue;
                ImGui.popStyleColor();
            }
            ImGui.endTable();
        }
        ImGui.sameLine(lineHeight);
        if (ImGui.button("+", lineHeight, lineHeight)) {
            ImGui.openPopup("add_light_popup");
        }
        if (ImGui.isItemHovered(0)) {
            ImGui.setTooltip("Add a new light to the world");
        }
        if (ImGui.beginPopup("add_light_popup")) {
            ImGui.text("Choose Light Type:");
            for (Light.Type lightType : this.lightTypes) {
                PointLight light;
                if (!ImGui.selectable(lightType.name())) continue;
                switch (lightType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case POINT: {
                        Light light2 = new PointLight().setRadius(15.0f);
                        break;
                    }
                    case AREA: {
                        Light light2 = new AreaLight().setDistance(15.0f).setOrientation(new Quaternionf().lookAlong((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19335().mul(-1.0f), (Vector3fc)class_310.method_1551().field_1773.method_19418().method_19336()));
                        break;
                    }
                    case DIRECTIONAL: {
                        Light light2 = light = new DirectionalLight().setDirection(0.0f, -1.0f, 0.0f);
                    }
                }
                if (light instanceof PositionedLight) {
                    PositionedLight positionedLight = light;
                    class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
                    positionedLight.setPosition(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215());
                }
                lightRenderer.addLight(((Light)light).setColor((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)).setBrightness(1.0f));
            }
            ImGui.endPopup();
        }
    }

    private static void renderLightComponents(Light light, int index) {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        ImBoolean notDeleted = new ImBoolean(true);
        if (ImGui.collapsingHeader(light.getType().name() + "#" + light.hashCode(), notDeleted)) {
            LightEditor.renderLightAttributeComponents(light, index);
        }
        if (!notDeleted.get()) {
            lightRenderer.removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light, int index) {
        Vector3fc lightColor = light.getColor();
        ImFloat editBrightness = new ImFloat(light.getBrightness());
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};
        ImGui.indent();
        if (ImGui.dragScalar("##brightness" + index, 8, editBrightness, 0.02f)) {
            light.setBrightness(editBrightness.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("brightness");
        if (ImGui.colorPicker3("##color" + index, editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("color");
        ImGui.newLine();
        switch (light.getType()) {
            case POINT: {
                LightEditor.renderPointLightAttributeComponents((PointLight)light, index);
                break;
            }
            case AREA: {
                LightEditor.renderAreaLightAttributeComponents((AreaLight)light, index);
                break;
            }
            case DIRECTIONAL: {
                LightEditor.renderDirectionalLightAttributeComponents((DirectionalLight)light, index);
            }
        }
        ImGui.unindent();
    }

    private static void renderPointLightAttributeComponents(PointLight light, int index) {
        Vector3d position = light.getPosition();
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editRadius = new ImFloat(light.getRadius());
        ImFloat editFalloff = new ImFloat(light.getFalloff());
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##x" + index, 9, editX, 0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##y" + index, 9, editY, 0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##z" + index, 9, editZ, 0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("position");
        if (ImGui.dragScalar("##radius" + index, 8, editRadius, 0.02f, 0.0f)) {
            light.setRadius(editRadius.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("radius");
        if (ImGui.dragScalar("##falloff" + index, 8, editFalloff, 0.01f, 0.0f)) {
            light.setFalloff(editFalloff.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("falloff");
    }

    private static void renderAreaLightAttributeComponents(AreaLight light, int index) {
        Vector2f size = light.getSize();
        Vector3d position = light.getPosition();
        Vector3f orientationAngles = light.getOrientation().getEulerAnglesXYZ(new Vector3f());
        float[] editSize = new float[]{size.x(), size.y()};
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editXRot = new ImFloat(orientationAngles.x() * 57.295776f);
        ImFloat editYRot = new ImFloat(orientationAngles.y() * 57.295776f);
        ImFloat editZRot = new ImFloat(orientationAngles.z() * 57.295776f);
        ImFloat editAngle = new ImFloat(light.getAngle() * 57.295776f);
        ImFloat editDistance = new ImFloat(light.getDistance());
        ImFloat editFalloff = new ImFloat(light.getFalloff());
        if (ImGui.dragFloat2("##size" + index, editSize, 0.02f, 1.0E-4f)) {
            light.setSize(editSize[0], editSize[1]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("size");
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##x" + index, 9, editX, 0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##y" + index, 9, editY, 0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##z" + index, 9, editZ, 0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("position");
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##xrot" + index, 8, editXRot, 0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(editXRot.get() * ((float)Math.PI / 180), orientationAngles.y(), orientationAngles.z()));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##yrot" + index, 8, editYRot, 0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(orientationAngles.x(), editYRot.get() * ((float)Math.PI / 180), orientationAngles.z()));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##zrot" + index, 8, editZRot, 0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(orientationAngles.x(), orientationAngles.y(), editZRot.get() * ((float)Math.PI / 180)));
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("orientation");
        if (ImGui.dragScalar("##angle" + index, 8, editAngle, 0.02f, 0.0f, 180.0f)) {
            light.setAngle(editAngle.get() * ((float)Math.PI / 180));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("angle");
        if (ImGui.dragScalar("##distance" + index, 8, editDistance, 0.02f, 0.0f)) {
            light.setDistance(editDistance.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("distance");
        if (ImGui.dragScalar("##falloff" + index, 8, editFalloff, 0.01f, 0.0f)) {
            light.setFalloff(editFalloff.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("falloff");
    }

    private static void renderDirectionalLightAttributeComponents(DirectionalLight light, int index) {
        Vector3f vector;
        Vector3fc direction = light.getDirection();
        float[] editDirection = new float[]{direction.x(), direction.y(), direction.z()};
        if (ImGui.dragFloat3("##direction" + index, editDirection, 0.005f) && !Float.isNaN((vector = new Vector3f(editDirection).normalize()).x()) && !Float.isNaN(vector.y()) && !Float.isNaN(vector.z())) {
            light.setDirection(editDirection[0], editDirection[1], editDirection[2]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("direction");
    }
}

