/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryUtil;

public final class TextureDownloader {
    private TextureDownloader() {
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, int texture, boolean flip) {
        GL11C.glBindTexture((int)3553, (int)texture);
        int base = GL11C.glGetTexParameteri((int)3553, (int)33084);
        int max = GL11C.glGetTexParameteri((int)3553, (int)33085);
        if (max == 1000) {
            max = 0;
        }
        ArrayList<CompletableFuture<Object>> result = new ArrayList<CompletableFuture<Object>>(max - base + 1);
        ExecutorService ioPool = class_156.method_27958();
        for (int level = base; level <= max; ++level) {
            int format = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4099);
            if (format == 6402) continue;
            Path outputFile = outputFolder.resolve(name + (String)(base == max ? "" : "-" + level) + ".png");
            if (!Files.exists(outputFile, new LinkOption[0])) {
                try {
                    Files.createFile(outputFile, new FileAttribute[0]);
                }
                catch (Exception e) {
                    result.add(CompletableFuture.failedFuture(e));
                    continue;
                }
            }
            int width = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
            ByteBuffer image = MemoryUtil.memAlloc((int)(width * height * 4));
            GL11C.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)image);
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                STBImageWrite.stbi_flip_vertically_on_write((boolean)flip);
                boolean success = STBImageWrite.stbi_write_png((CharSequence)outputFile.toString(), (int)width, (int)height, (int)4, (ByteBuffer)image, (int)0);
                MemoryUtil.memFree((Buffer)image);
                if (!success) {
                    throw new CompletionException(new IOException("Failed to write image to: " + outputFile));
                }
            }, ioPool);
            result.add(future);
        }
        return CompletableFuture.allOf((CompletableFuture[])result.toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, class_1044 texture, boolean flip) {
        return TextureDownloader.save(name, outputFolder, texture.method_4624(), flip);
    }

    public static CompletableFuture<?> save(String name, Path outputFolder, class_2960 texture, boolean flip) {
        class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(texture);
        return TextureDownloader.save(name, outputFolder, (class_1044)(abstractTexture != null ? abstractTexture : class_1047.method_4540()), flip);
    }
}

