/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public record ProgramDefinition(@Nullable class_2960 vertex, @Nullable class_2960 tesselationControl, @Nullable class_2960 tesselationEvaluation, @Nullable class_2960 geometry, @Nullable class_2960 fragment, @Nullable class_2960 compute, String[] definitions, Map<String, String> definitionDefaults, Map<String, ShaderTextureSource> textures, Map<Integer, class_2960> shaders) {

    public static class Deserializer
    implements JsonDeserializer<ProgramDefinition> {
        private String[] deserializeDefinitions(JsonArray json, Map<String, String> defaults) throws JsonParseException {
            ArrayList<String> definitions = new ArrayList<String>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonElement element = json.get(i);
                if (element.isJsonPrimitive()) {
                    definitions.add(element.getAsJsonPrimitive().getAsString());
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject definitionJson = element.getAsJsonObject();
                    Set entrySet = definitionJson.entrySet();
                    if (entrySet.size() != 1) {
                        throw new JsonSyntaxException("Expected definitions[" + i + "] to have one element, had " + entrySet.size());
                    }
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)entrySet);
                    definitions.add((String)entry.getKey());
                    defaults.put((String)entry.getKey(), class_3518.method_15287((JsonElement)((JsonElement)entry.getValue()), (String)("definitions[" + i + "]")));
                    continue;
                }
                throw new JsonSyntaxException("Expected definitions[" + i + "] to be a JsonPrimitive or Object, was " + class_3518.method_15266((JsonElement)element));
            }
            return (String[])definitions.toArray(String[]::new);
        }

        private Map<String, ShaderTextureSource> deserializeTextures(JsonObject json) throws JsonParseException {
            HashMap<String, ShaderTextureSource> textures = new HashMap<String, ShaderTextureSource>();
            for (Map.Entry entry : json.entrySet()) {
                String name = (String)entry.getKey();
                DataResult texture = ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
                if (texture.error().isPresent()) {
                    throw new JsonSyntaxException("Failed to deserialize texture: " + name + ". " + ((DataResult.PartialResult)texture.error().get()).message());
                }
                textures.put(name, (ShaderTextureSource)texture.result().orElseThrow());
            }
            ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return Collections.unmodifiableMap(textures);
        }

        public ProgramDefinition deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Map<String, String> definitionDefaults;
            String[] definitions;
            JsonObject json = element.getAsJsonObject();
            class_2960 vertex = (class_2960)context.deserialize(json.get("vertex"), class_2960.class);
            class_2960 tesselationControl = (class_2960)context.deserialize(json.get("tesselation_control"), class_2960.class);
            class_2960 tesselationEvaluation = (class_2960)context.deserialize(json.get("tesselation_evaluation"), class_2960.class);
            class_2960 geometry = (class_2960)context.deserialize(json.get("geometry"), class_2960.class);
            class_2960 fragment = (class_2960)context.deserialize(json.get("fragment"), class_2960.class);
            class_2960 compute = (class_2960)context.deserialize(json.get("compute"), class_2960.class);
            if (json.has("definitions")) {
                HashMap<String, String> defaults = new HashMap<String, String>();
                definitions = this.deserializeDefinitions(json.getAsJsonArray("definitions"), defaults);
                definitionDefaults = Collections.unmodifiableMap(defaults);
            } else {
                definitions = new String[]{};
                definitionDefaults = Collections.emptyMap();
            }
            Map<String, ShaderTextureSource> textures = json.has("textures") ? this.deserializeTextures(json.getAsJsonObject("textures")) : Collections.emptyMap();
            HashMap<Integer, class_2960> sources = new HashMap<Integer, class_2960>();
            if (vertex != null) {
                sources.put(35633, vertex);
            }
            if (tesselationControl != null) {
                sources.put(36488, tesselationControl);
            }
            if (tesselationEvaluation != null) {
                sources.put(36487, tesselationEvaluation);
            }
            if (geometry != null) {
                sources.put(36313, geometry);
            }
            if (fragment != null) {
                sources.put(35632, fragment);
            }
            if (compute != null) {
                sources.put(37305, compute);
            }
            return new ProgramDefinition(vertex, tesselationControl, tesselationEvaluation, geometry, fragment, compute, definitions, definitionDefaults, textures, Collections.unmodifiableMap(sources));
        }
    }
}

