/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.ext.VertexBufferExtension;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_291;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class InstancedLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final int MAX_UPLOADS = 400;
    protected final int lightSize;
    protected int maxLights;
    private final List<T> visibleLights;
    private final class_291 vbo;
    private final int instancedVbo;
    private int oldSize;

    public InstancedLightRenderer(int maxLights, int lightSize) {
        this.maxLights = maxLights;
        this.lightSize = lightSize;
        this.visibleLights = new ArrayList<T>();
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.instancedVbo = GL15C.glGenBuffers();
        this.vbo.method_1353();
        this.vbo.method_1352(this.createMesh());
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBufferData((int)34962, (long)((long)maxLights * (long)this.lightSize), (int)35048);
        this.setupBufferState();
        GL15C.glBindBuffer((int)34962, (int)0);
        class_291.method_1354();
    }

    protected class_287.class_7433 createMesh() {
        return LightTypeRenderer.createQuad();
    }

    protected abstract void setupBufferState();

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    private void updateAllLights(List<T> lights) {
        this.oldSize = lights.size();
        try (MemoryStack stack = MemoryStack.stackPush();){
            int pointer = 0;
            long offset = 0L;
            ByteBuffer dataBuffer = stack.malloc(Math.min(400, lights.size()) * this.lightSize);
            for (Light light : lights) {
                light.clean();
                dataBuffer.position(pointer++ * this.lightSize);
                ((InstancedLight)((Object)light)).store(dataBuffer);
                if (pointer < 400) continue;
                dataBuffer.rewind();
                GL15C.glBufferSubData((int)34962, (long)offset, (ByteBuffer)dataBuffer);
                offset += (long)dataBuffer.capacity();
                pointer = 0;
            }
            if (pointer > 0) {
                dataBuffer.rewind();
                GL15C.nglBufferSubData((int)34962, (long)offset, (long)((long)pointer * (long)this.lightSize), (long)MemoryUtil.memAddress((ByteBuffer)dataBuffer));
            }
        }
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights, CullFrustum frustum) {
        this.visibleLights.clear();
        for (Light light : lights) {
            if (!light.isVisible(frustum)) continue;
            this.visibleLights.add(light);
        }
        if (this.visibleLights.isEmpty()) {
            return;
        }
        this.vbo.method_1353();
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        if (this.visibleLights.size() > this.maxLights) {
            this.oldSize = 0;
            this.maxLights = (int)Math.max(Math.ceil((double)this.maxLights / 2.0), (double)this.visibleLights.size() * 1.5);
            GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35040);
        }
        if (this.oldSize != this.visibleLights.size()) {
            this.updateAllLights(this.visibleLights);
        } else {
            for (int i = 0; i < this.visibleLights.size(); ++i) {
                Light light;
                light = (Light)this.visibleLights.get(i);
                if (!light.isDirty()) continue;
                light.clean();
                try (MemoryStack stack = MemoryStack.stackPush();){
                    ByteBuffer buffer = stack.malloc(this.lightSize);
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL15C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                    continue;
                }
            }
        }
        this.setupRenderState(lightRenderer, this.visibleLights);
        lightRenderer.applyShader();
        ((VertexBufferExtension)this.vbo).veil$drawInstanced(this.visibleLights.size());
        this.clearRenderState(lightRenderer, this.visibleLights);
        GL15C.glBindBuffer((int)34962, (int)0);
        class_291.method_1354();
    }

    public void free() {
        this.vbo.close();
        GL15C.glDeleteBuffers((int)this.instancedVbo);
    }
}

