/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import foundry.veil.ext.CompositeStateExtension;
import foundry.veil.mixin.client.stage.RenderStateShardAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1921;
import net.minecraft.class_4668;
import org.jetbrains.annotations.ApiStatus;

public class RenderTypeStageRegistry {
    private static final Map<String, List<class_4668>> STAGES = new HashMap<String, List<class_4668>>();
    private static final Set<GenericStage> GENERIC_STAGES = new HashSet<GenericStage>();
    private static final Set<class_1921.class_4687> CREATED_RENDER_TYPES = new HashSet<class_1921.class_4687>();

    public static synchronized void addStage(class_1921 renderType, class_4668 ... shards) {
        RenderTypeStageRegistry.addStage(((RenderStateShardAccessor)renderType).getName(), shards);
    }

    public static synchronized void addStage(String name, class_4668 ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        STAGES.computeIfAbsent(name, unused -> new ArrayList()).addAll(Arrays.asList(shards));
        for (class_1921.class_4687 renderType : CREATED_RENDER_TYPES) {
            RenderTypeStageRegistry.inject(renderType);
        }
    }

    public static synchronized void addGenericStage(Predicate<class_1921.class_4687> filter, class_4668 ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        GENERIC_STAGES.add(new GenericStage(filter, shards));
        for (class_1921.class_4687 renderType : CREATED_RENDER_TYPES) {
            RenderTypeStageRegistry.inject(renderType);
        }
    }

    @ApiStatus.Internal
    public static void inject(class_1921.class_4687 renderType) {
        List<class_4668> shards = STAGES.get(((RenderStateShardAccessor)renderType).getName());
        if (shards != null) {
            shards = new ArrayList<class_4668>(shards);
        }
        for (GenericStage stage : GENERIC_STAGES) {
            if (!stage.filter.test(renderType)) continue;
            if (shards == null) {
                shards = new ArrayList<class_4668>(Arrays.asList(stage.shards));
                continue;
            }
            shards.addAll(Arrays.asList(stage.shards));
        }
        if (shards != null) {
            ((CompositeStateExtension)renderType.method_35784()).veil$addShards(shards);
        }
        CREATED_RENDER_TYPES.add(renderType);
    }

    private record GenericStage(Predicate<class_1921.class_4687> filter, class_4668[] shards) {
    }
}

