/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import java.nio.ByteBuffer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.NativeResource;

public class CameraMatrices
implements NativeResource {
    private static final int SIZE = 324;
    private final ShaderBlock<CameraMatrices> block = ShaderBlock.withSize(324, CameraMatrices::write);
    private final Matrix4f projectionMatrix = new Matrix4f();
    private final Matrix4f inverseProjectionMatrix = new Matrix4f();
    private final Matrix4f viewMatrix = new Matrix4f();
    private final Matrix4f inverseViewMatrix = new Matrix4f();
    private final Matrix3f inverseViewRotMatrix = new Matrix3f();
    private final Vector3f cameraPosition = new Vector3f();
    private float nearPlane = 0.0f;
    private float farPlane = 0.0f;

    private void write(ByteBuffer buffer) {
        this.projectionMatrix.get(0, buffer);
        this.inverseProjectionMatrix.get(64, buffer);
        this.viewMatrix.get(128, buffer);
        this.inverseViewMatrix.get(192, buffer);
        this.inverseViewRotMatrix.get3x4(256, buffer);
        this.cameraPosition.get(304, buffer);
        buffer.putFloat(316, this.nearPlane);
        buffer.putFloat(320, this.farPlane);
    }

    public void update(Matrix4fc projection, Matrix4fc modelView, Vector3fc pos, float zNear, float zFar) {
        this.projectionMatrix.set(projection);
        this.projectionMatrix.invert(this.inverseProjectionMatrix);
        this.viewMatrix.set(modelView);
        this.viewMatrix.invert(this.inverseViewMatrix);
        this.inverseViewMatrix.normal(this.inverseViewRotMatrix);
        this.nearPlane = zNear;
        this.farPlane = zFar;
        this.cameraPosition.set(pos);
        this.block.set(this);
        VeilRenderSystem.bind("CameraMatrices", this.block);
    }

    public void updateGui() {
        this.projectionMatrix.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        this.projectionMatrix.invert(this.inverseProjectionMatrix);
        this.viewMatrix.identity();
        this.inverseViewMatrix.identity();
        this.inverseViewRotMatrix.identity();
        this.nearPlane = this.projectionMatrix.transformPosition(0.0f, 0.0f, -1.0f, this.cameraPosition).z();
        this.farPlane = this.projectionMatrix.transformPosition(0.0f, 0.0f, 1.0f, this.cameraPosition).z();
        this.cameraPosition.set(0.0f);
        this.block.set(this);
        VeilRenderSystem.bind("CameraMatrices", this.block);
    }

    public void unbind() {
        VeilRenderSystem.unbind(this.block);
    }

    public Matrix4fc getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4fc getInverseProjectionMatrix() {
        return this.inverseProjectionMatrix;
    }

    public Matrix4fc getViewMatrix() {
        return this.viewMatrix;
    }

    public Matrix4fc getInverseViewMatrix() {
        return this.inverseViewMatrix;
    }

    public Matrix3f getInverseViewRotMatrix() {
        return this.inverseViewRotMatrix;
    }

    public Vector3fc getCameraPosition() {
        return this.cameraPosition;
    }

    public float getNearPlane() {
        return this.nearPlane;
    }

    public float getFarPlane() {
        return this.farPlane;
    }

    public void free() {
        this.block.free();
    }
}

