/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import com.google.gson.Gson;
import foundry.veil.api.molang.VeilMolang;
import foundry.veil.platform.services.VeilPlatform;
import gg.moonflower.molangcompiler.api.MolangCompiler;
import java.util.ServiceLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Veil {
    public static final String MODID = "veil";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"veil");
    public static final boolean DEBUG;
    public static final boolean IMGUI;
    public static final Gson GSON;
    private static final VeilPlatform PLATFORM;

    @ApiStatus.Internal
    public static void init() {
        LOGGER.info("Veil is initializing.");
        if (DEBUG) {
            LOGGER.info("Veil Debug Enabled");
        }
        if (!IMGUI) {
            LOGGER.info("ImGui Disabled");
        }
        VeilMolang.set(MolangCompiler.create(1, Veil.class.getClassLoader()));
    }

    public static class_2960 veilPath(String path) {
        return new class_2960(MODID, path);
    }

    public static VeilPlatform platform() {
        return PLATFORM;
    }

    static {
        GSON = new Gson();
        PLATFORM = ServiceLoader.load(VeilPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected platform implementation"));
        boolean arm = System.getProperty("os.arch").equals("arm") || System.getProperty("os.arch").startsWith("aarch64");
        DEBUG = System.getProperty("veil.debug") != null;
        IMGUI = !arm && System.getProperty("veil.disableImgui") == null;
    }
}

