package foundry.veil.api.quasar.registry;

import foundry.veil.Veil;
import foundry.veil.api.quasar.particle.RenderStyle;
import foundry.veil.platform.registry.RegistrationProvider;
import org.jetbrains.annotations.ApiStatus;

import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

/**
 * Registry for all render styles.
 */
public class RenderStyleRegistry {

    public static final class_5321<class_2378<RenderStyle>> REGISTRY_KEY = class_5321.method_29180(Veil.veilPath("quasar/render_style"));
    private static final RegistrationProvider<RenderStyle> PROVIDER = RegistrationProvider.get(REGISTRY_KEY, Veil.MODID);
    public static final class_2378<RenderStyle> REGISTRY = PROVIDER.asVanillaRegistry();

    public static final Supplier<RenderStyle.Cube> CUBE = register("cube", new RenderStyle.Cube());
    public static final Supplier<RenderStyle.Billboard> BILLBOARD = register("billboard", new RenderStyle.Billboard());

    @ApiStatus.Internal
    public static void bootstrap() {
    }

    private static <T extends RenderStyle> Supplier<T> register(String name, T shape) {
        return PROVIDER.register(name, () -> shape);
    }
}
