package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.mixin.accessor.BufferBuilderAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

import java.util.*;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class CachedBufferSource implements class_4597, NativeResource {

    private final Map<class_1921, class_287> buffers = new Object2ObjectArrayMap<>();
    private final Set<class_287> startedBuffers = new HashSet<>();
    private Optional<class_1921> lastState = Optional.empty();

    @Override
    public class_4588 getBuffer(class_1921 renderType) {
        // Make sure buffers that can't be batched are ended correctly
        if (this.lastState.isPresent() && !this.lastState.get().method_43332()) {
            this.endLastBatch();
        }
        this.lastState = renderType.method_24296();

        class_287 builder = this.buffers.computeIfAbsent(renderType, t -> new class_287(t.method_22722()));
        if (this.startedBuffers.add(builder)) {
            builder.method_1328(renderType.method_23033(), renderType.method_23031());
        }

        return builder;
    }

    @Override
    public void free() {
        // Make sure we free the memory before trying to dispose of the objects
        for (class_287 value : this.buffers.values()) {
            MemoryUtil.memFree(((BufferBuilderAccessor) value).getBuffer());
        }
        this.buffers.clear();
        this.startedBuffers.clear();
        this.lastState = Optional.empty();
    }

    public void endLastBatch() {
        this.lastState.ifPresent(this::endBatch);
        this.lastState = Optional.empty();
    }

    public void endBatch() {
        for (class_1921 renderType : this.buffers.keySet()) {
            this.endBatch(renderType);
        }
    }

    public void endBatch(class_1921 renderType) {
        class_287 builder = this.buffers.get(renderType);
        if (builder != null && this.startedBuffers.remove(builder)) {
            renderType.method_23012(builder, RenderSystem.getVertexSorting());
            if (Objects.equals(this.lastState, renderType.method_24296())) {
                this.lastState = Optional.empty();
            }
        }
    }
}
