package foundry.veil.api.client.pose;

import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_759;

/**
 * An interface for a pose that can be applied to a model. Some data is passed to the pose, and the pose can modify the player model at runtime.
 *
 * @see ExtendedPose
 */
public interface VeilPoseable {
    /**
     * Apply the pose to the model
     *
     * @param model the model to apply the pose to
     */
    void pose(class_572<?> model);

    /**
     * Apply the pose to the item renderer
     *
     * @param itemRenderer the item renderer
     */
    void poseItem(class_759 itemRenderer);

    /**
     * Apply the pose to the item renderer when the player is using an item
     *
     * @param itemRenderer the item renderer
     */
    void poseItemUsing(class_759 itemRenderer);

    /**
     * Apply the pose to the left arm
     *
     * @param leftArm the left arm
     */
    void poseLeftArm(class_630 leftArm);

    /**
     * Apply the pose to the right arm
     *
     * @param rightArm the right arm
     */
    void poseRightArm(class_630 rightArm);

    /**
     * Apply the pose to the left leg
     *
     * @param leftLeg the left leg
     */
    void poseLeftLeg(class_630 leftLeg);

    /**
     * Apply the pose to the right leg
     *
     * @param rightLeg the right leg
     */
    void poseRightLeg(class_630 rightLeg);

    /**
     * Apply the pose to the head
     *
     * @param head the head
     */
    void poseHead(class_630 head);

    /**
     * Apply the pose to the body
     *
     * @param body the body
     */
    void poseBody(class_630 body);

    /**
     * Apply the pose to the main hand
     *
     * @param mainHand the main hand
     */
    void poseMainHand(class_630 mainHand);

    /**
     * Apply the pose to the main hand when the player is in first person
     *
     * @param stack the pose stack
     */
    void poseMainHandFirstPerson(class_4587 stack);

    /**
     * Apply the pose to the off hand
     *
     * @param offHand the off hand
     */
    void poseOffHand(class_630 offHand);

    /**
     * Apply the pose to the off hand when the player is in first person
     *
     * @param stack the pose stack
     */
    void poseOffHandFirstPerson(class_4587 stack);

    /**
     * Whether to force render the offhand in first person
     *
     * @return true if the offhand should be rendered
     */
    boolean forceRenderOffhand();

    /**
     * Whether to force render the main hand in first person
     *
     * @return true if the main hand should be rendered
     */
    boolean forceRenderMainHand();

    /**
     * Whether to override the item transform
     *
     * @return true if the item transform should be overridden
     */
    boolean overrideItemTransform();
}
