package foundry.veil.api.client.graveyard.render.mesh;

import foundry.veil.api.client.graveyard.skeleton.InterpolatedBone;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface ModelMesh {

    ModelMesh EMPTY = (part, pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha) -> {
    };

    default void update(@Nullable InterpolatedBone part, InterpolatedSkeleton skeleton, int ticks, float partialTick) {
    }

    void render(@Nullable InterpolatedBone part, class_4587 pPoseStack, class_4588 pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha);

    default void render(class_4587 pPoseStack, class_4588 pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.render(null, pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    record Vertex(float x, float y, float z) {
    }

    record UV(float u, float v) {
    }

    class Face {
        protected final Vertex[] vertices;
        protected final UV[] uvs;
        protected final Vector3f normal;

        protected Face(Vertex a, Vertex b, Vertex c, Vertex d, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, boolean mirrored, class_2350 pDirection) {
            this.vertices = new Vertex[]{a, b, c, d};
            this.uvs = new UV[]{new UV(u1 / textureWidth, v0 / textureHeight), new UV(u0 / textureWidth, v0 / textureHeight), new UV(u0 / textureWidth, v1 / textureHeight), new UV(u1 / textureWidth, v1 / textureHeight)};
            if (mirrored) {
                int i = this.vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = this.vertices[j];
                    UV uv = this.uvs[j];
                    this.vertices[j] = this.vertices[i - 1 - j];
                    this.uvs[j] = this.uvs[i - 1 - j];
                    this.vertices[i - 1 - j] = vertex;
                    this.uvs[i - 1 - j] = uv;
                }
            }

            this.normal = pDirection.method_23955();
            if (mirrored) {
                this.normal.mul(-1.0F, 1.0F, 1.0F);
            }
            this.normal.mul(-1.0F, -1.0F, -1.0F);
        }

        protected Face(Vertex[] vertices, UV[] uvs, Vector3f normal) {
            this.vertices = vertices;
            this.uvs = uvs;
            this.normal = normal;
        }
    }
}
