package foundry.veil.mixin.tooltip;

import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.ColorTheme;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import foundry.veil.api.client.tooltip.anim.TooltipTimeline;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

@Mixin(class_2586.class)
public class BlockEntityMixin implements Tooltippable {

    @Unique
    private List<class_2561> veil$tooltip = new ArrayList<>();

    @Unique
    private ColorTheme veil$theme;

    @Unique
    private List<VeilUIItemTooltipDataHolder> veil$tooltipDataHolder = new ArrayList<>();

    @Unique
    private TooltipTimeline veil$timeline = null;

    @Unique
    private boolean veil$worldspace = true;

    @Unique
    private boolean veil$tooltipEnabled = false;

    @Unique
    private int veil$tooltipX = 0;

    @Unique
    private int veil$tooltipY = 0;

    @Unique
    private int veil$tooltipWidth = 0;

    @Unique
    private int veil$tooltipHeight = 0;

    @Override
    public List<class_2561> getTooltip() {
        return this.veil$tooltip;
    }

    @Override
    public boolean isTooltipEnabled() {
        return this.veil$tooltipEnabled;
    }

    @Override
    public class_2487 saveTooltipData() {
        class_2487 tag = new class_2487();
        tag.method_10556("tooltipEnabled", this.veil$tooltipEnabled);
        tag.method_10569("tooltipX", this.veil$tooltipX);
        tag.method_10569("tooltipY", this.veil$tooltipY);
        tag.method_10569("tooltipWidth", this.veil$tooltipWidth);
        tag.method_10569("tooltipHeight", this.veil$tooltipHeight);
        tag.method_10556("worldspace", this.veil$worldspace);

        if (this.veil$theme != null) {
            class_2487 themeTag = new class_2487();
            for (Map.Entry<String, Color> entry : this.veil$theme.getColorsMap().entrySet()) {
                String key = entry.getKey() != null ? entry.getKey() : "";
                themeTag.method_10569(key, entry.getValue().getRGB());
            }
            tag.method_10566("theme", themeTag);
        }
        return tag;
    }

    @Override
    public void loadTooltipData(class_2487 tag) {
        this.veil$tooltipEnabled = tag.method_10577("tooltipEnabled");
        this.veil$tooltipX = tag.method_10550("tooltipX");
        this.veil$tooltipY = tag.method_10550("tooltipY");
        this.veil$tooltipWidth = tag.method_10550("tooltipWidth");
        this.veil$tooltipHeight = tag.method_10550("tooltipHeight");
        this.veil$worldspace = tag.method_10577("worldspace");

        if (this.veil$theme != null) {
            this.veil$theme.clear();
        }
        if (tag.method_10573("theme", class_2487.field_33260)) {
            if (this.veil$theme == null) {
                this.veil$theme = new ColorTheme();
            }
            class_2487 themeTag = tag.method_10562("theme");
            for (String key : themeTag.method_10541()) {
                this.veil$theme.addColor(key, Color.of(themeTag.method_10550(key)));
            }
        }
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.veil$tooltip = tooltip;
    }

    @Override
    public void addTooltip(class_2561 tooltip) {
        this.veil$tooltip.add(tooltip);
    }

    @Override
    public void addTooltip(List<class_2561> tooltip) {
        this.veil$tooltip.addAll(tooltip);
    }

    @Override
    public void addTooltip(String tooltip) {
        this.veil$tooltip.add(class_2561.method_30163(tooltip));
    }

    @Override
    public ColorTheme getTheme() {
        return this.veil$theme;
    }

    @Override
    public void setTheme(ColorTheme theme) {
        this.veil$theme = theme;
    }

    @Override
    public void setBackgroundColor(int color) {
        this.veil$theme.addColor("background", Color.of(color));
    }

    @Override
    public void setTopBorderColor(int color) {
        this.veil$theme.addColor("topBorder", Color.of(color));
    }

    @Override
    public void setBottomBorderColor(int color) {
        this.veil$theme.addColor("bottomBorder", Color.of(color));
    }

    @Override
    public boolean getWorldspace() {
        return this.veil$worldspace;
    }

    @Override
    public TooltipTimeline getTimeline() {
        return this.veil$timeline;
    }

    @Override
    public class_1799 getStack() {
        return class_1799.field_8037;
    }

    @Override
    public int getTooltipWidth() {
        return this.veil$tooltipWidth;
    }

    @Override
    public int getTooltipHeight() {
        return this.veil$tooltipHeight;
    }

    @Override
    public int getTooltipXOffset() {
        return this.veil$tooltipX;
    }

    @Override
    public int getTooltipYOffset() {
        return this.veil$tooltipHeight;
    }

    @Override
    public List<VeilUIItemTooltipDataHolder> getItems() {
        return this.veil$tooltipDataHolder;
    }

    @Inject(method = "saveAdditional", at = @At("RETURN"))
    public void saveAdditional(class_2487 $$0, CallbackInfo ci) {
        $$0.method_10566("tooltipData", this.saveTooltipData());
    }

    @Inject(method = "load", at = @At("RETURN"))
    public void loadAdditional(class_2487 $$0, CallbackInfo ci) {
        this.loadTooltipData($$0.method_10562("tooltipData"));
    }

}
