package foundry.veil.impl;

import foundry.veil.Veil;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilBuiltinPacks {

    public static void registerPacks(VeilBuiltinPacks.Context context) {
        if (Veil.platform().isDevelopmentEnvironment()) {
            context.register(Veil.veilPath("test_shaders"), false);
            context.register(Veil.veilPath("test_particles"), false);
        }

        if (!Veil.SODIUM) {
            context.register(VeilDeferredRenderer.PACK_ID, false);
        }
    }

    @FunctionalInterface
    public interface Context {

        void register(class_2960 id, boolean defaultEnabled);
    }
}
