package foundry.veil.api.resource.type;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.impl.resource.action.TextEditAction;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public record VeilShaderIncludeResource(VeilResourceInfo resourceInfo) implements VeilShaderResource<VeilShaderIncludeResource> {

    @Override
    public List<VeilResourceAction<VeilShaderIncludeResource>> getActions() {
        return List.of(new TextEditAction<>());
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload() {
        class_2960 id = ShaderManager.INCLUDE_LISTER.method_45115(this.resourceInfo.location());

        ShaderManager shaderManager = VeilRenderSystem.renderer().getShaderManager();
        ShaderManager deferredShaderManager = VeilRenderSystem.renderer().getDeferredRenderer().getDeferredShaderManager();
        Set<class_2960> programs = getShaders(id, shaderManager);
        Set<class_2960> deferredPrograms = getShaders(id, deferredShaderManager);

        for (class_2960 program : programs) {
            shaderManager.scheduleRecompile(program);
        }

        for (class_2960 program : deferredPrograms) {
            deferredShaderManager.scheduleRecompile(program);
        }
    }

    private static Set<class_2960> getShaders(class_2960 id, ShaderManager shaderManager) {
        Set<class_2960> programs = new HashSet<>();
        for (Map.Entry<class_2960, ShaderProgram> entry : shaderManager.getShaders().entrySet()) {
            ShaderProgram program = entry.getValue();
            for (CompiledShader shader : program.getShaders().values()) {
                if (shader.includes().contains(id)) {
                    programs.add(entry.getKey());
                    break;
                }
            }
        }
        return programs;
    }
}
