package foundry.veil.api.resource;

import java.util.OptionalInt;
import net.minecraft.class_2561;

public interface VeilResourceAction<T extends VeilResource<?>> {

    /**
     * @return The name of the action
     */
    class_2561 getName();

    /**
     * @return A brief description of the action
     */
    class_2561 getDescription();

    /**
     * @return The icon to display for the action
     */
    OptionalInt getIcon();

    /**
     * Performs the action on the specified resource
     */
    void perform(VeilEditorEnvironment environment, T resource);

}
