package foundry.veil.api.client.render.framebuffer;

import foundry.veil.Veil;
import net.minecraft.class_2960;

/**
 * Default framebuffer names for use with {@link FramebufferManager#getFramebuffer(class_2960)}.
 *
 * @author Ocelot
 */
public final class VeilFramebuffers {

    private VeilFramebuffers() {
    }

    public static final class_2960 MAIN = new class_2960("main");
    public static final class_2960 FIRST_PERSON = buffer("first_person");
    public static final class_2960 OPAQUE = buffer("opaque");
    public static final class_2960 OPAQUE_FINAL = buffer("opaque_final");
    public static final class_2960 TRANSPARENT = buffer("transparent");
    public static final class_2960 TRANSPARENT_FINAL = buffer("transparent_final");
    public static final class_2960 OPAQUE_LIGHT = buffer("opaque_light");
    public static final class_2960 TRANSPARENT_LIGHT = buffer("transparent_light");
    public static final class_2960 POST = buffer("post");

    private static class_2960 buffer(String name) {
        return new class_2960(Veil.MODID, name);
    }
}
