/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.FramebufferPostStage;
import java.util.Objects;
import net.minecraft.class_2960;

public class CopyPostStage
extends FramebufferPostStage {
    public static final Codec<CopyPostStage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FramebufferManager.FRAMEBUFFER_CODEC.fieldOf("in").forGetter(CopyPostStage::getIn), (App)FramebufferManager.FRAMEBUFFER_CODEC.fieldOf("out").forGetter(FramebufferPostStage::getOut), (App)Codec.BOOL.optionalFieldOf("color", (Object)true).forGetter(CopyPostStage::copyColor), (App)Codec.BOOL.optionalFieldOf("depth", (Object)false).forGetter(CopyPostStage::copyDepth), (App)Codec.BOOL.optionalFieldOf("linear", (Object)false).forGetter(CopyPostStage::isLinear)).apply((Applicative)instance, CopyPostStage::new));
    private final int mask;
    private final int filter;

    public CopyPostStage(class_2960 in, class_2960 out, boolean copyColor, boolean copyDepth, boolean linear) {
        super(in, out, false);
        this.mask = (copyColor ? 16384 : 0) | (copyDepth ? 256 : 0);
        this.filter = linear ? 9729 : 9728;
    }

    @Override
    public void apply(PostPipeline.Context context) {
        AdvancedFbo in = context.getFramebuffer(this.getIn());
        AdvancedFbo out = context.getFramebuffer(this.getOut());
        if (in != null && out != null) {
            in.resolveToAdvancedFbo(out, this.mask, this.filter);
        }
    }

    @Override
    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType() {
        return PostPipelineStageRegistry.COPY.get();
    }

    @Override
    public class_2960 getIn() {
        return Objects.requireNonNull(super.getIn());
    }

    public int getMask() {
        return this.mask;
    }

    public int getFilter() {
        return this.filter;
    }

    public boolean copyColor() {
        return (this.mask & 0x4000) > 0;
    }

    public boolean copyDepth() {
        return (this.mask & 0x100) > 0;
    }

    public boolean isLinear() {
        return this.filter == 9729;
    }
}

