package foundry.veil.mixin.client.stage;

import com.google.common.collect.ImmutableList;
import foundry.veil.ext.CompositeStateExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import net.minecraft.class_1921;
import net.minecraft.class_4668;

@Mixin(class_1921.class_4688.class)
public class CompositeStateMixin implements CompositeStateExtension {

    @Mutable
    @Final
    @Shadow
    ImmutableList<class_4668> states;

    @Override
    public void veil$addShards(Collection<class_4668> shards) {
        if (shards.isEmpty()) {
            return;
        }

        ImmutableList.Builder<class_4668> builder = new ImmutableList.Builder<>();
        builder.addAll(this.states);
        builder.addAll(shards);
        this.states = builder.build();
    }
}
