package foundry.veil.impl.compat;

import foundry.veil.Veil;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_5944;

@ApiStatus.Internal
public class IrisShaderMap {

    private static final boolean IRIS = Veil.platform().isModLoaded("iris");
    private static Supplier<Set<class_5944>> loadedShadersSupplier = Collections::emptySet;

    public static Set<class_5944> getLoadedShaders() {
        return loadedShadersSupplier.get();
    }

    public static void setLoadedShadersSupplier(Supplier<Set<class_5944>> loadedShadersSupplier) {
        IrisShaderMap.loadedShadersSupplier = loadedShadersSupplier;
    }

    public static boolean isEnabled() {
        return IRIS;
    }
}
