/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.modifier.SimpleShaderModification;
import foundry.veil.impl.client.render.shader.transformer.VeilJobParameters;
import foundry.veil.impl.glsl.GlslParser;
import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VertexShaderModification
extends SimpleShaderModification {
    private final Attribute[] attributes;
    private final Map<String, String> mapper;

    public VertexShaderModification(int version, int priority, class_2960[] includes, @Nullable String output, @Nullable String uniform, ShaderModification.Function[] functions, Attribute[] attributes) {
        super(version, priority, includes, output, uniform, functions);
        this.attributes = attributes;
        this.mapper = new HashMap<String, String>(this.attributes.length);
    }

    @Override
    public void inject(GlslTree tree, VeilJobParameters parameters) throws GlslSyntaxException, IOException {
        if (this.attributes.length > 0) {
            Int2ObjectArrayMap validInputs = new Int2ObjectArrayMap();
            tree.fields().forEach(arg_0 -> VertexShaderModification.lambda$inject$0((Map)validInputs, arg_0));
            this.mapper.clear();
            for (Attribute attribute : this.attributes) {
                Attribute sourceAttribute = (Attribute)validInputs.get(attribute.index);
                if (sourceAttribute == null) {
                    tree.getBody().add(0, GlslParser.parseExpression("layout(location = " + attribute.index + ") in " + attribute.type + " " + attribute.name));
                    this.mapper.put(attribute.name, attribute.name);
                    continue;
                }
                if (!sourceAttribute.type.equals(attribute.type)) {
                    throw new IOException("Expected attribute " + attribute.index + " to be " + attribute.type + " but was " + sourceAttribute.type);
                }
                this.mapper.put(attribute.name, sourceAttribute.name);
            }
        }
        super.inject(tree, parameters);
    }

    @Override
    protected String getPlaceholder(String key) {
        String name = this.mapper.get(key);
        return name != null ? name : super.getPlaceholder(key);
    }

    private static /* synthetic */ void lambda$inject$0(Map validInputs, GlslNewNode node) {
        GlslSpecifiedType type = node.getType();
        for (GlslTypeQualifier qualifier : type.getQualifiers()) {
            GlslTypeQualifier.StorageType storage;
            if (!(qualifier instanceof GlslTypeQualifier.StorageType) || (storage = (GlslTypeQualifier.StorageType)qualifier) != GlslTypeQualifier.StorageType.IN) continue;
            validInputs.put(validInputs.size(), new Attribute(validInputs.size(), type.getSpecifier().getSourceString(), node.getName()));
            break;
        }
    }

    public record Attribute(int index, String type, String name) {
    }
}

